<?php
class ModelAccountReturn extends Model {
	public function addReturn($data) {

	    foreach ($data['model'] as $key => $item){
            $this->db->query("INSERT INTO ps_return SET 
            order_id = '" . (int)$data['order_id'] . "', 
            customer_id = '" . (int)$this->customer->getId() . "', 
            firstname = '" . $this->db->escape($data['firstname']) . "', 
            lastname = '" . $this->db->escape($data['lastname']) . "', 
            email = '" . $this->db->escape($data['email']) . "', 
            telephone = '" . $this->db->escape($data['telephone']) . "', 
            product = '" . $this->db->escape($data['product'][$key]) . "', 
            product_id = '" . $data['product_id'][$key] . "', 
            model = '" . $this->db->escape($data['model'][$key]) . "', 
            quantity = '" . (int)$data['quantity'][$key] . "', 
            opened = '" . (int)$data['opened'] . "', 
            prefer_pay_coupon = '" . (isset($data['prefer_pay_coupon']) ? 1 : 0) . "', 
            return_or_change = '" . $this->db->escape($data['return_or_change']) . "', 
            return_reason_id = '" . (int)$data['return_reason_id'] . "', 
            return_status_id = '" . (int)$this->config->get('config_return_status_id') . "', 
            comment = '" . $this->db->escape($data['comment']) . "', 
            date_ordered = '" . $this->db->escape($data['date_ordered']) . "', 
            date_added = NOW(), 
            date_modified = NOW() ");

            $return_status = 0;
            if($data['return_or_change'] == 'İade'){
                $return_status = 1;
            }else if($data['return_or_change'] == 'İptal'){
                $return_status = 2;
            }else if($data['return_or_change'] == 'Değişim'){
                $return_status = 3;
            }

            $this->db->query("UPDATE ps_order_product SET return_status = '". $return_status ."' WHERE order_product_id = '". (int)$data['order_product_id'][$key] ."' ");
        }


		$return_id = $this->db->getLastId();

		return $return_id;
	}

	public function getReturn($return_id) {
		$query = $this->db->query("SELECT r.return_id, r.order_id, r.firstname, r.lastname, r.email, r.telephone, r.product, r.model, r.quantity, r.opened, (SELECT rr.name FROM " . DB_PREFIX . "return_reason rr WHERE rr.return_reason_id = r.return_reason_id AND rr.language_id = '" . (int)$this->config->get('config_language_id') . "') AS reason, (SELECT ra.name FROM " . DB_PREFIX . "return_action ra WHERE ra.return_action_id = r.return_action_id AND ra.language_id = '" . (int)$this->config->get('config_language_id') . "') AS action, (SELECT rs.name FROM " . DB_PREFIX . "return_status rs WHERE rs.return_status_id = r.return_status_id AND rs.language_id = '" . (int)$this->config->get('config_language_id') . "') AS status, r.comment, r.date_ordered, r.date_added, r.date_modified FROM `" . DB_PREFIX . "return` r WHERE r.return_id = '" . (int)$return_id . "' AND r.customer_id = '" . $this->customer->getId() . "'");

		return $query->row;
	}

	public function getReturns($start = 0, $limit = 20) {
		if ($start < 0) {
			$start = 0;
		}

		if ($limit < 1) {
			$limit = 20;
		}

		$query = $this->db->query("SELECT r.return_id, r.order_id, r.firstname, r.lastname, rs.name as status, r.date_added FROM `" . DB_PREFIX . "return` r LEFT JOIN " . DB_PREFIX . "return_status rs ON (r.return_status_id = rs.return_status_id) WHERE r.customer_id = '" . $this->customer->getId() . "' AND rs.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY r.return_id DESC LIMIT " . (int)$start . "," . (int)$limit);

		return $query->rows;
	}

	public function getTotalReturns() {
		$query = $this->db->query("SELECT COUNT(*) AS total FROM `" . DB_PREFIX . "return`WHERE customer_id = '" . $this->customer->getId() . "'");

		return $query->row['total'];
	}

	public function getReturnHistories($return_id) {
		$query = $this->db->query("SELECT rh.date_added, rs.name AS status, rh.comment FROM " . DB_PREFIX . "return_history rh LEFT JOIN " . DB_PREFIX . "return_status rs ON rh.return_status_id = rs.return_status_id WHERE rh.return_id = '" . (int)$return_id . "' AND rs.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY rh.date_added ASC");

		return $query->rows;
	}

    public function getOrder($order_id)
    {
        $query = $this->db->query("SELECT * FROM ps_order_product WHERE order_id = '". (int)$order_id ."' ");
        if(isset($query->row['order_product_id'])){
            return $query->row;
        }else{
            return false;
        }


	}

    public function calcPreferPayCoupon($products)
    {
        $total = 0;
        $order_id = 0;
        foreach ($products as $product){
            $result = $this->db->query("SELECT * FROM ps_order_product WHERE order_product_id = '". (int)$product['product_id'] ."' ")->row;
            $total += ($result['total'] + $result['tax']);
            $order_id = $result['order_id'];
        }

        //$this->db->query("SELECT");



        return $total * 1.10;


	}

    public function createPreferPayCoupon($order_id, $prefer_pay_coupon_total)
    {
        $get_order_info = $this->db->query("SELECT telephone FROM ps_order WHERE order_id = '". (int)$order_id ."' ")->row;

        $alfabet = strtoupper("abcdefghijklmnopqrstuvwxyz");
        $phone_nummber = $order_id . @rand(0,99);
        $text = '';

        for ($i=0; $i< strlen($phone_nummber); $i++){
            $key = $phone_nummber[$i];
            $text .= $alfabet[$key];
        }

        $this->db->query("INSERT INTO ps_coupon SET 
        name = 'Prefer Pay Coupon', 
        `code` = '". $this->db->escape($text) ."', 
        type = 'F', 
        discount = '". $prefer_pay_coupon_total ."', 
        date_start = '2020-08-04', 
        date_end = '2022-07-31', 
        uses_total = 1, 
        uses_customer = 1, 
        return_coupon = 0, 
        date_added = NOW(), 
        status = 1 ");


        return $text;

	}
	
}
