<?php
class ModelAccountAddress extends Model {
    public function addAddress($data) {

        $this->db->query("INSERT INTO ps_address SET 
		customer_id = '" . (int)$this->customer->getId() . "', 
		firstname = '" . $this->db->escape($data['firstname']) . "', 
		lastname = '" . $this->db->escape($data['lastname']) . "', 
		company = '" . $this->db->escape(isset($data['company']) ? json_encode($data['company']) : '') . "', 
		company_taxadmin = '" . $this->db->escape(isset($data['company_taxadmin']) ? json_encode($data['company_taxadmin']) : '') . "', 
		company_taxno = '" . $this->db->escape(isset($data['company_taxno']) ? json_encode($data['company_taxno']) : '') . "', 
		address_1 = '" . $this->db->escape($data['address_1']) . "',  
		postcode = '" . $this->db->escape($data['postcode']) . "', 
		city = '" . $this->db->escape($data['city']) . "', 
		zone_id = '" . (int)$data['zone_id'] . "', 
		country_id = '" . (int)$data['country_id'] . "', 
		custom_field = '" . $this->db->escape(isset($data['custom_field']) ? json_encode($data['custom_field']) : '') . "' ");

        $address_id = $this->db->getLastId();

        if (!empty($data['default'])) {
            $this->db->query("UPDATE ps_customer SET 
			address_id = '" . (int)$address_id . "' WHERE customer_id = '" . (int)$this->customer->getId() . "'");
        }

        return $address_id;
    }

    public function editAddress($address_id, $data) {

        $this->db->query("UPDATE ps_address SET 
		firstname = '" . $this->db->escape($data['firstname']) . "', 
		lastname = '" . $this->db->escape($data['lastname']) . "', 
		company = '" . $this->db->escape($data['company']) . "', 
		address_1 = '" . $this->db->escape($data['address_1']) . "',  
		postcode = '" . $this->db->escape($data['postcode']) . "', 
		city = '" . $this->db->escape($data['city']) . "', 
		zone_id = '" . (int)$data['zone_id'] . "', 
		country_id = '" . (int)$data['country_id'] . "', 
		custom_field = '" . $this->db->escape(isset($data['custom_field']) ? json_encode($data['custom_field']) : '') . "' 
		WHERE address_id  = '" . (int)$address_id . "' AND customer_id = '" . (int)$this->customer->getId() . "'");

        if (!empty($data['default'])) {
            $this->db->query("UPDATE ps_customer SET 
			address_id = '" . (int)$address_id . "' 
			WHERE customer_id = '" . (int)$this->customer->getId() . "'");
        }
    }

    public function deleteAddress($address_id) {

        $this->db->query("DELETE FROM ps_address WHERE address_id = '" . (int)$address_id . "' AND customer_id = '" . (int)$this->customer->getId() . "'");
    }

    public function getAddress($address_id) {
        $address_query = $this->db->query("SELECT DISTINCT * FROM ps_address WHERE address_id = '" . (int)$address_id . "' AND customer_id = '" . (int)$this->customer->getId() . "'");

        if ($address_query->num_rows) {
            $country_query = $this->db->query("SELECT * FROM ps_country WHERE country_id = '" . (int)$address_query->row['country_id'] . "'");

            if ($country_query->num_rows) {
                $country = $country_query->row['name'];
                $iso_code_2 = $country_query->row['iso_code_2'];
                $iso_code_3 = $country_query->row['iso_code_3'];
                $address_format = $country_query->row['address_format'];
            } else {
                $country = '';
                $iso_code_2 = '';
                $iso_code_3 = '';
                $address_format = '';
            }

            $zone_query = $this->db->query("SELECT * FROM ps_zone WHERE zone_id = '" . (int)$address_query->row['zone_id'] . "'");

            if ($zone_query->num_rows) {
                $zone = $zone_query->row['name'];
                $zone_code = $zone_query->row['code'];
            } else {
                $zone = '';
                $zone_code = '';
            }

            $city_query = $this->db->query("SELECT * FROM ps_district WHERE district_id = '". (int)$address_query->row['city'] ."' ");
            if ($city_query->num_rows) {
                $city = $city_query->row['district_name'];
            } else if($address_query->row['city']){
                $city = $address_query->row['city'];
            }else{
                $city = '';
            }

            $address_data = array(
                'address_id'     => $address_query->row['address_id'],
                'firstname'      => $address_query->row['firstname'],
                'lastname'       => $address_query->row['lastname'],
                'company'        => $address_query->row['company'],
                'company_taxadmin'        => $address_query->row['company_taxadmin'],
                'company_taxno'        => $address_query->row['company_taxno'],
                'address_1'      => $address_query->row['address_1'],
                'address_2'      => $address_query->row['address_2'],
                'postcode'       => $address_query->row['postcode'],
                'city'           => $city,
                'zone_id'        => $address_query->row['zone_id'],
                'zone'           => $zone,
                'zone_code'      => $zone_code,
                'country_id'     => $address_query->row['country_id'],
                'country'        => $country,
                'iso_code_2'     => $iso_code_2,
                'iso_code_3'     => $iso_code_3,
                'address_format' => $address_format,
                'custom_field'   => json_decode($address_query->row['custom_field'], true)
            );

            return $address_data;
        } else {
            return false;
        }
    }

    public function getAddresses() {
        $address_data = array();

        $query = $this->db->query("SELECT * FROM ps_address WHERE customer_id = '" . (int)$this->customer->getId() . "'");

        foreach ($query->rows as $result) {
            $country_query = $this->db->query("SELECT * FROM ps_country WHERE country_id = '" . (int)$result['country_id'] . "'");

            if ($country_query->num_rows) {
                $country = $country_query->row['name'];
                $iso_code_2 = $country_query->row['iso_code_2'];
                $iso_code_3 = $country_query->row['iso_code_3'];
                $address_format = $country_query->row['address_format'];
            } else {
                $country = '';
                $iso_code_2 = '';
                $iso_code_3 = '';
                $address_format = '';
            }

            $zone_query = $this->db->query("SELECT * FROM ps_zone WHERE zone_id = '" . (int)$result['zone_id'] . "'");

            if ($zone_query->num_rows) {
                $zone = $zone_query->row['name'];
                $zone_code = $zone_query->row['code'];
            } else {
                $zone = '';
                $zone_code = '';
            }

            $city_query = $this->db->query("SELECT * FROM ps_district WHERE district_id = '". (int)$result['city'] ."' ");
            if ($city_query->num_rows) {
                $city = $city_query->row['district_name'];
            } else if($result['city']){
                $city = $result['city'];
            }else{
                $city = '';
            }

            $address_data[$result['address_id']] = array(
                'address_id'     => $result['address_id'],
                'firstname'      => $result['firstname'],
                'lastname'       => $result['lastname'],
                'company'        => $result['company'],
                'company_taxadmin' => $result['company_taxadmin'],
                'company_taxno'  => $result['company_taxno'],
                'address_1'      => $result['address_1'],
                'address_2'      => $result['address_2'],
                'postcode'       => $result['postcode'],
                'city'           => $city,
                'zone_id'        => $result['zone_id'],
                'zone'           => $zone,
                'zone_code'      => $zone_code,
                'country_id'     => $result['country_id'],
                'country'        => $country,
                'iso_code_2'     => $iso_code_2,
                'iso_code_3'     => $iso_code_3,
                'address_format' => $address_format,
                'custom_field'   => json_decode($result['custom_field'], true)

            );
        }

        return $address_data;
    }

    public function getAddresses2($customer_id = 0) {
        $address_data = array();

        $query = $this->db->query("SELECT * FROM ps_address WHERE customer_id = '" . (int)$customer_id . "'");

        foreach ($query->rows as $result) {
            $country_query = $this->db->query("SELECT * FROM ps_country WHERE country_id = '" . (int)$result['country_id'] . "'");

            if ($country_query->num_rows) {
                $country = $country_query->row['name'];
                $iso_code_2 = $country_query->row['iso_code_2'];
                $iso_code_3 = $country_query->row['iso_code_3'];
                $address_format = $country_query->row['address_format'];
            } else {
                $country = '';
                $iso_code_2 = '';
                $iso_code_3 = '';
                $address_format = '';
            }

            $zone_query = $this->db->query("SELECT * FROM ps_zone WHERE zone_id = '" . (int)$result['zone_id'] . "'");

            if ($zone_query->num_rows) {
                $zone = $zone_query->row['name'];
                $zone_code = $zone_query->row['code'];
            } else {
                $zone = '';
                $zone_code = '';
            }

            $city_query = $this->db->query("SELECT * FROM ps_district WHERE district_id = '". (int)$result['city'] ."' ");
            if ($city_query->num_rows) {
                $city = $city_query->row['district_name'];
            } else if($result['city']){
                $city = $result['city'];
            }else{
                $city = '';
            }

            $address_data[$result['address_id']] = array(
                'address_id'     => $result['address_id'],
                'firstname'      => $result['firstname'],
                'lastname'       => $result['lastname'],
                'company'        => $result['company'],
                'company_taxadmin' => $result['company_taxadmin'],
                'company_taxno'  => $result['company_taxno'],
                'address_1'      => $result['address_1'],
                'address_2'      => $result['address_2'],
                'postcode'       => $result['postcode'],
                'city'           => $city,
                'zone_id'        => $result['zone_id'],
                'zone'           => $zone,
                'zone_code'      => $zone_code,
                'country_id'     => $result['country_id'],
                'country'        => $country,
                'iso_code_2'     => $iso_code_2,
                'iso_code_3'     => $iso_code_3,
                'address_format' => $address_format,
                'custom_field'   => json_decode($result['custom_field'], true)

            );
        }

        return $address_data;
    }

    public function getTotalAddresses() {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM ps_address WHERE customer_id = '" . (int)$this->customer->getId() . "'");

        return $query->row['total'];
    }
}