<?php
class ControllerToolScottyCron extends Controller{
    use scottycargo;

    public function index() {
      set_time_limit(-1);

      $this->load->model('checkout/order');

      $shipping_result_status = array(
        'CREATED', // Paket için barkod oluşturuldu
        'CUSTODY', // Paket için ilk Scotty zimmeti alındığında tetiklenir
        'TRANSFER', // Paket için dağıtım şubesine varmadan önceki araç zimmetlerinde tetiklenir
        'RESPONSIBILITY', // Paket için şube/hub zimmetlerinde tetiklenir
        'STARTED', // paket teslim edilmek üzere dağıtım zimmeti alındığında tetiklenir
        'DELIVERED', // Paket teslim edildiğinde tetiklenir
        'UNDELIVERED', // Paket Teslim edilemediğinde tetiklenir
        'RETRY', // Tekrar dağıtıma çıkarılacak
        'CANCELLED', // Paket iade durumu için tetiklenir
      );

      //https://www.deercase.com/index.php?route=tool/scotty_cron
      //https://www.deercase.com/index.php?route=tool/scotty_cron&order_id=504765

       /*                                                                         
      $kargo_sonuc = NULL; 418728
      if(isset($this->request->get['kargo_sonuc'])){
        $kargo_sonuc = $this->request->get['kargo_sonuc'];
      }
      */

      if(isset($this->request->get['order_id'])){
        $order_id = $this->request->get['order_id'];
      }else{
        $order_id = 0;
      }

      if(!$order_id){
        $results = $this->db->query("SELECT * FROM ps_order_scottycargo 
        WHERE scottycargo_sonuc IS NULL 
        OR scottycargo_sonuc IN ('CREATED', 'CUSTODY', 'TRANSFER', 'RESPONSIBILITY','STARTED', 'RETRY', 'WAITING')
        ORDER BY RAND() ")->rows;
      }else{
        $results = $this->db->query("SELECT * FROM ps_order_scottycargo WHERE order_id = '". (int)$order_id ."' ")->rows;
      }
      

      echo count($results) . " Adet Kargo işlenecektir. <br>";


      foreach ($results as $key => $result){
        if($key >= 50){
            die();
        }

        $order = $this->model_checkout_order->getOrder($result['order_id']);

            if($order AND !in_array($order['order_status_id'], array(11,7,5,2))){

                $movements = $this->getScottyPackageMovements($result['scottycargo_barcode']);
                //var_dump($movements ); die();
                $url = $this->db->query("SELECT * FROM ps_order_scottycargo WHERE scottycargo_id = '" . $result['scottycargo_id'] . "'")->row['scottycargo_url'];
                if(isset($movements['data']) && count($movements['data']) > 0) {

                  foreach($movements['data'] as $movement) {
                    $step_query = $this->db->query("SELECT * FROM ps_scottycargo_steps
                      WHERE scottycargo_id = '". $result['scottycargo_id'] ."' 
                      AND scottycargo_action = '". $this->db->escape($movement['status']) ."' ")
                      ->row;                
                      if(!$step_query){
                            // kargo durumu veritabanına eklenmediyse ekle.
                            echo 'Order ID: '. $order['order_id'] .' => Status: ' . $movement['status'] . "<br>";
                            
                            $this->db->query("INSERT INTO ps_scottycargo_steps SET 
                                scottycargo_id = '". $result['scottycargo_id'] ."', 
                                scottycargo_action = '". $this->db->escape($movement['status']) ."' ");

                            // kargonun durumunu güncelle
                            $this->db->query("UPDATE ps_order_scottycargo SET
                                scottycargo_sonuc = '" . $movement['status'] . "'
                                WHERE scottycargo_id = '". $result['scottycargo_id'] ."' ");
                            
                            $this->addHistory($order, $url, $movement['status'], true);
                      }else{
                        echo 'Order ID: '. $order['order_id'] .' => Status: ' . $movement['status'] . " İşlenmiş Durum! <br>";
                      }
                  }
                }

            }else{
                echo 'Order ID: '. $order['order_id'] .' => Order Status ID: ' . $order['order_status_id'] . '<br>';
                if($order['order_status_id'] == 5 || $order['order_status_id'] == 7 || $order['order_status_id'] == 11){
                    $this->db->query("UPDATE ps_order_scottycargo SET scottycargo_sonuc = 'DELIVERED' WHERE scottycargo_id = '". $result['scottycargo_id'] ."' ");
                }
            }
      }
    }


    private function addHistory($order_info, $url, $event, $notify, $unitName = ''){

      $this->load->language('tool/scottycargo_cron');

      $this->load->model('checkout/order');

      $order_status_id = $order_info['order_status_id'];

      if($order_status_id == 7){
          return false;
      }

      $comment = '';
      if($event == 'CREATED' || $event == 'CUSTODY'){
      //if($event == 'CREATED'){
          $comment = sprintf($this->language->get('text_kargo_yuklendi'), $order_info['firstname'], $order_info['lastname'], $order_info['order_id'], $url);
          $order_status_id = 17;
          $mesaj = "Sayın ". $order_info['firstname'] . ' ' . $order_info['lastname'] .", ". $order_info['order_id'] ." no'lu siparişiniz Scotty Kargo'ya teslim edilmiştir.  ". $url;
          if($notify){
             // $this->sendSms($order_info, $mesaj);
          }

      }else if($event == 'STARTED'){
          $comment .= "Sayın ". $order_info['firstname'] . ' ' . $order_info['lastname'] .", ". $order_info['order_id'] . " no'lu siparişiniz gün içerisinde adresinize teslim edilmek üzere dağıtıma çıkarılmıştır. Takip Linki (".$url.")";
          $order_status_id = 19;
          $mesaj = "Sayın ". $order_info['firstname'] . ' ' . $order_info['lastname'] .", ". $order_info['order_id'] . " no'lu siparişiniz gün içerisinde adresinize teslim edilmek üzere dağıtıma çıkarılmıştır. Takip Linki (".$url.")";
          if($notify){
            //$this->sendSms($order_info, $mesaj);
          }
      }else if($event == 'UNDELIVERED'){
          $comment .= "Sayın ". $order_info['firstname'] . ' ' . $order_info['lastname'] .", Ürün teslimatınız başarısız olduğu için Scotty Kargo şubesinde bekletilmektedir. ";
          $order_status_id = 18;
          $mesaj = "Sayın ". $order_info['firstname'] . ' ' . $order_info['lastname'] .", Ürün teslimatınız başarısız olduğu için Scotty Kargo şubesinde bekletilmektedir. ";
          if($notify){
              //$this->sendSms($order_info, $mesaj);
          }
      }else if($event == 'CANCELLED'){
          $comment .= "Kargo alıcı tarafından kabul edilmedi. Teslim alinamayan Kargo geri gönderildi.";
          $order_status_id = 21;
      }else if($event == 'DELIVERED'){
          $comment = sprintf($this->language->get('text_kargo_teslim_edildi'), $order_info['firstname'], $order_info['lastname'], $order_info['order_id']);
          $order_status_id = 5;
      }

      if ($order_info && $comment!='') {
          $this->model_checkout_order->addOrderHistory($order_info['order_id'], $order_status_id, $comment, $notify, 1);
          //echo $order_info['order_id'] . " Başarılı! <br>";
      }

  }

    private function sendSms($order_info, $mesaj)
    {
        $log = new Log("ScottyCargoSendSmsLog.txt");
        $log->write($mesaj);

        if($this->config->get('netgsm_status')) {
            $this->load->model('setting/setting');
            $netgsm_ayarlari = $this->model_setting_setting->getSetting('netgsm');

            if($netgsm_ayarlari['netgsm_status'] == 1){
                $netgsmsms = new Netgsmsms($netgsm_ayarlari['netgsm_user'],$netgsm_ayarlari['netgsm_pass'],$netgsm_ayarlari['netgsm_input_smstitle'],isset($netgsm_ayarlari['netgsm_turkishChar']));
                $smsgonder = $netgsmsms->sendSMS($order_info['telephone'],$mesaj);
            }
        }
    }

}
?>