<?php
require_once DIR_SYSTEM . "library" . DIRECTORY_SEPARATOR . "iyzico" . DIRECTORY_SEPARATOR . "IyzipayBootstrap.php";
class ControllerToolIyzicoRefund extends Controller{

    private $base_url = "https://api.iyzipay.com";
    private $valid_currency = array("TRY", "GBP", "USD", "EUR", "IRR");

    public function index()
    {

        $json = array();

        if(isset($this->request->get['order_id']) OR isset($this->request->post['order_id'])){

            if(isset($this->request->get['order_id'])){
                $order_id = (int)$this->request->get['order_id'];
            }else{
                $order_id = (int)$this->request->post['order_id'];
            }


            $this->load->model('checkout/order');
            $order = $this->model_checkout_order->getOrder($order_id);
            if($order){

                $iyzico_order = $this->db->query("SELECT * FROM ps_iyzico_order_test WHERE order_id = '". (int)$order_id ."' AND request_type = 'get_auth' ")->row;
                if(isset($iyzico_order['api_response']) AND $iyzico_order['api_response']){
                    $iyzico_order = json_decode($iyzico_order['api_response'], true);
                    if(isset($iyzico_order['itemTransactions'][0])){
                        $iyzico_order = $iyzico_order['itemTransactions'][0];

                        $paymentTransactionId = $iyzico_order['paymentTransactionId'];
                        $order_ip = $order['ip'];
                        $price = number_format($order['total'], 2, '.', '');

                        //var_dump($price); die();

                        IyzipayBootstrap::init();

                        $merchant_api_id = $this->config->get('iyzico_checkout_form_api_id_live');
                        $merchant_secret_key = $this->config->get('iyzico_checkout_form_secret_key_live');

                        $options = new \Iyzipay\Options();
                        $options->setApiKey($merchant_api_id);
                        $options->setSecretKey($merchant_secret_key);
                        $options->setBaseUrl($this->base_url);

                        $request = new \Iyzipay\Request\CreateRefundRequest();
                        $request->setLocale(\Iyzipay\Model\Locale::TR);
                        $request->setPaymentTransactionId($paymentTransactionId);
                        $request->setPrice($price);
                        $request->setIp($order_ip);
                        $request->setIp(\Iyzipay\Model\Currency::TL);

                        $refund = \Iyzipay\Model\Refund::create($request, $options);

                        var_dump($refund); die();

                        /*
                        if($refund->getStatus() == 'failure'){
                            $json['error'] = $refund->getErrorMessage();
                        }else if($refund->getStatus() == 'success'){

                            $this->db->query("UPDATE ps_iyzico_order_refunds SET total_refunded = '". $refund->getPrice() ."' WHERE order_id = '". (int)$order_id ."' ");

                            $comment = $refund->getPrice() . ' ' . $refund->getCurrency() . ' Tutatı geri iade/iptal yapılmıştır.';
                            $this->load->model('checkout/order');
                            $this->model_checkout_order->addOrderHistory($order_id, 11, $comment, false, false);

                            $json['success'] = $comment;
                        }*/


                    }


                }


            }


        }else{
            $json['error'] = "Sipairş numarası bulunamadı!";
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));



    }


}