<?php

class ControllerToolDr extends Controller {
    public function index() {
        set_time_limit(-1);

        require_once DIR_SYSTEM . 'PHPExcel/Classes/PHPExcel.php';
        $this->load->model('catalog/product');

        $products = $this->db->query("SELECT DISTINCT * FROM ps_product p
        LEFT JOIN ps_product_description pd ON (p.product_id = pd.product_id)
        WHERE p.dr = '" . 1 . "'")->rows;
        
        if ($this->request->server['HTTPS']) {
            $img_prefix = $this->config->get('config_ssl') . 'image/';
        } else {
            $img_prefix = $this->config->get('config_url') . 'image/';
        }
        
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0)

            ->setCellValue('A1','ID(MODEL)')
            ->setCellValue('B1','ÜRÜN ADI')
            ->setCellValue('C1','ADET')
            ->setCellValue('D1','PSF')
            ->setCellValue('E1','TELEFON MODELİ')
            ->setCellValue('F1','MATERYAL')
            ->setCellValue('G1','RENK')
            ->setCellValue('H1','GÖRSEL LİNKİ');

        $file_name = $this->config->get('config_name').'-'.@date("Y-m-d-His")."-d&r.xls" ;


        $row_i = 2;
        foreach ($products as $product){

            $product_attrs = $this->model_catalog_product->getProductAttributes($product['product_id']);
            $material = $product_attrs[0]['attribute'][0]['name'];
            $color = $product_attrs[1]['attribute'][0]['name'];
            $psf = $this->currency->format($this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
            if(strpos($color, $material)!==false) {
                $color = str_replace($material, '', $color);
            }
            $phone_model = $this->model_catalog_product->getCategoryByProductId($product['product_id']);
            $phone_model = str_replace(' Telefon Kılıfı', '', $phone_model[1])['name'];
            $img = $img_prefix . $product['image'];

            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A'. $row_i, $product['product_id'])
                ->setCellValue('B'. $row_i, $product['name'])
                ->setCellValue('C'. $row_i, $product['quantity'])
                ->setCellValue('D'. $row_i, $psf)
                ->setCellValue('E'. $row_i, $phone_model)
                ->setCellValue('F'. $row_i, $material)
                ->setCellValue('G'. $row_i, $color)
                ->setCellValue('H'. $row_i, $img);

            $row_i++;

        }


        $objPHPExcel->getActiveSheet()->setTitle('Simple');

        $objPHPExcel->setActiveSheetIndex(0);

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$file_name.'"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }
}