<?php 
class ControllerQuickCheckoutVoucher extends Controller {
	public function index() {
		$data = $this->load->language('checkout/checkout');
		$data = array_merge($data, $this->load->language('quickcheckout/checkout'));
		
		$points_total = 0;
		$points_total = $this->cart->getSubTotal();
		
		foreach($this->cart->getTaxes() as $tax) {
			$points_total += $tax;
		}

		$points_total = number_format($points_total, 2, '.', '');
		
		$data['entry_reward'] = sprintf($this->language->get('entry_reward'), $points_total, $this->customer->getRewardPoints());
		
		if ($points_total && $this->customer->isLogged()) {
			$data['reward'] = true;
		} else {
			$data['reward'] = false;
		}
		
		$points = $this->customer->getRewardPoints();
		$data['text_reward_points'] = $points;
		if($points < 1){
			$data['text_reward_points'] = 0.00;
		}
		
		// All variables
		$data['voucher_module'] = $this->config->get('quickcheckout_voucher');
		$data['coupon_module'] = $this->config->get('quickcheckout_coupon');
		$data['reward_module'] = $this->config->get('quickcheckout_reward');

		if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/quickcheckout/voucher.tpl')){
		    return $this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/quickcheckout/voucher', $data);
		}else{ 
		    return $this->load->view(DIR_TEMPLATE . 'default/template/quickcheckout/voucher', $data);
		}
	
		
	}
	
	public function validateCoupon() {
		$this->load->language('checkout/checkout');
		$this->load->language('quickcheckout/checkout');

		$json = array();
		
		if (!isset($this->request->post['coupon']) || empty($this->request->post['coupon'])) {
			$this->request->post['coupon'] = '';
			$this->session->data['coupon'] = '';
		}
		
		$this->load->model('extension/total/coupon');
		
		if ($this->request->post['coupon'] == '') {
			unset($this->session->data['coupon']);
			
			$json['success'] = $this->language->get('text_coupon_removed');
		} else {
			$coupon_info = $this->model_extension_total_coupon->getCoupon($this->request->post['coupon']);

			/**
             * 01.09.20 return coupon cannot be used width any promotions (ali a.)
             */
			if (!$coupon_info) {			
				$json['error']['warning'] = $this->language->get('error_coupon');
			}else if($this->config->get('promotion')['4al2ode']){
                //$expo = explode('-', $this->request->post['coupon']);
                if($this->cart->countProducts() >= 4){
                    if (isset($this->session->data['coupon'])) {
                        unset($this->session->data['coupon']);
                    }
                    $json['error']['warning'] = $this->language->get('error_campaign_coupon');
					$json['error']['warning'] = '(4 Al 2 Öde) kapsamında iki kampanya birleştirilemez.';
                }

				
            }
			else if (isset($this->session->data['campaign_price_total']) && $coupon_info['return_coupon'] == 1) {

                if (isset($this->session->data['coupon'])) {
                    unset($this->session->data['coupon']);
                }

                $json['error']['warning'] = $this->language->get('error_return_coupon');
            }
            /**
             * end of update (ali a.)
             */
			
			if (!$json) {
				$this->session->data['coupon'] = $this->request->post['coupon'];

				$json['success'] = $this->language->get('text_coupon');
			}
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));		
	}
	
	public function validateVoucher() {
		$this->load->language('checkout/checkout');
		$this->load->language('quickcheckout/checkout');
		
		$json = array();
		
		if (!isset($this->request->post['voucher']) || empty($this->request->post['voucher'])) {
			$this->request->post['voucher'] = '';
			$this->session->data['voucher'] = '';
		}
		
		$this->load->model('extension/total/voucher');
		
		if ($this->request->post['voucher'] == '') {
			unset($this->session->data['voucher']);
			
			$json['success'] = $this->language->get('text_voucher_removed');
		} else {
			$voucher_info = $this->model_extension_total_voucher->getVoucher($this->request->post['voucher']);
			
			if (!$voucher_info) {
				$json['error']['warning'] = $this->language->get('error_voucher');
			}
			
			if (!$json) {
				$this->session->data['voucher'] = $this->request->post['voucher'];

				$json['success'] = $this->language->get('text_coupon');
			}
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	
	public function validateReward() {
		$this->load->language('checkout/checkout');
		$this->load->language('quickcheckout/checkout');
		
		$points = $this->customer->getRewardPoints();
		
		$points_total = 0;
		$points_total = $this->cart->getSubTotal();

		foreach($this->cart->getTaxes() as $tax) {
			$points_total += $tax;
		}

		$points_total = number_format($points_total, 2, '.', '');
		
		$json = array();
		
		if ($this->request->post['reward'] == '') {
			unset($this->session->data['reward']);
			
			$json['success'] = $this->language->get('text_reward_removed');
		} else {
			if (empty($this->request->post['reward'])) {
				$json['error']['warning'] = $this->language->get('error_reward');
			}
		
			if ($this->request->post['reward'] > $points) {
				$json['error']['warning'] = sprintf($this->language->get('error_points'), $this->request->post['reward']);
			}
			
			if ($this->request->post['reward'] > $points_total) {
				$json['error']['warning'] = sprintf($this->language->get('error_maximum'), $points_total);
			}
			
			if (!$json) {
				$this->session->data['reward'] = abs($this->request->post['reward']);
				
				$json['success'] = $this->language->get('text_reward');
			}
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));	
	}
}