<?php  
class ControllerQuickCheckoutTerms extends Controller {
  	public function index() {
		$data = $this->load->language('checkout/checkout');
		$data = array_merge($data, $this->load->language('quickcheckout/checkout'));
		
		if ($this->config->get('config_checkout_id')) {
			$this->load->model('catalog/information');
			
			$information_info = $this->model_catalog_information->getInformation($this->config->get('config_checkout_id'));
			
			if ($information_info) {
				$data['text_agree'] = sprintf($this->language->get('text_agree'), $this->url->link('information/information/agree', 'information_id=' . $this->config->get('config_checkout_id'), true), $information_info['title'], $information_info['title']);
			} else {
				$data['text_agree'] = '';
			}
		} else {
			$data['text_agree'] = '';
		}

		if ($this->config->get('config_checkout_id2')) {
			$this->load->model('catalog/information');
			
			$information_info = $this->model_catalog_information->getInformation($this->config->get('config_checkout_id2'));
			
			if ($information_info) {
				$data['text_agree2'] = sprintf($this->language->get('text_agree'), $this->url->link('information/information/agree', 'information_id=' . $this->config->get('config_checkout_id2'), true), $information_info['title'], $information_info['title']);
			} else {
				$data['text_agree2'] = '';
			}
		} else {
			$data['text_agree2'] = '';
		}
		
		// All variables
		$data['confirmation_page'] = $this->config->get('quickcheckout_confirmation_page');
		
		$proceed_button_text = $this->config->get('quickcheckout_proceed_button_text');
		
		if (!empty($proceed_button_text[$this->config->get('config_language_id')])) {
			$data['button_continue'] = $proceed_button_text[$this->config->get('config_language_id')];
		}

		if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/quickcheckout/terms.tpl')){
		    return $this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/quickcheckout/terms', $data);
		}else{ 
		    return $this->load->view(DIR_TEMPLATE . 'default/template/quickcheckout/terms', $data);
		}
		
		
	}
	
	public function validate() {
		$this->load->language('checkout/checkout');
		$this->load->language('quickcheckout/checkout');
		
		$json = array();
		
		if ($this->config->get('config_checkout_id')) {
			$this->load->model('catalog/information');
				
			$information_info = $this->model_catalog_information->getInformation($this->config->get('config_checkout_id'));
				
			if ($information_info && !isset($this->request->post['agree'])) {
				$json['error']['warning'] = sprintf($this->language->get('error_agree'), $information_info['title']);
			}
		}

		if ($this->config->get('config_checkout_id2')) {
			$this->load->model('catalog/information');
				
			$information_info = $this->model_catalog_information->getInformation($this->config->get('config_checkout_id2'));
				
			if ($information_info && !isset($this->request->post['agree2'])) {
				$json['error']['warning'] = sprintf($this->language->get('error_agree'), $information_info['title']);
			}
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}