<?php
class ControllerQuickCheckoutGuest extends Controller {
    public function index() {

        $data = $this->load->language('checkout/checkout');
        $data = array_merge($data, $this->load->language('quickcheckout/checkout'));

        $data['guest_checkout'] = ($this->config->get('config_checkout_guest') && !$this->config->get('config_customer_price') && !$this->cart->hasDownload());

        $data['customer_groups'] = array();

        if (is_array($this->config->get('config_customer_group_display'))) {
            $this->load->model('account/customer_group');

            $customer_groups = $this->model_account_customer_group->getCustomerGroups();

            foreach ($customer_groups as $customer_group) {
                if (in_array($customer_group['customer_group_id'], $this->config->get('config_customer_group_display'))) {
                    $data['customer_groups'][] = $customer_group;
                }
            }
        }

        if (isset($this->session->data['guest']['customer_group_id'])) {
            $data['customer_group_id'] = $this->session->data['guest']['customer_group_id'];
        } else {
            $data['customer_group_id'] = $this->config->get('config_customer_group_id');
        }

        if(isset($this->session->data['ps_guest_firstname'])){
            $data['firstname'] = $this->session->data['ps_guest_firstname'];
        }else if (isset($this->session->data['guest']['firstname'])) {
            $data['firstname'] = $this->session->data['guest']['firstname'];
        }else {
            $data['firstname'] = '';
        }

        if(isset($this->session->data['ps_guest_lastname'])){
            $data['lastname'] = $this->session->data['ps_guest_lastname'];
        }else if (isset($this->session->data['guest']['lastname'])) {
            $data['lastname'] = $this->session->data['guest']['lastname'];
        } else {
            $data['lastname'] = '';
        }

        if(isset($this->session->data['ps_guest_email'])){
            $data['email'] = $this->session->data['ps_guest_email'];
        }else if (isset($this->session->data['guest']['email'])) {
            $data['email'] = $this->session->data['guest']['email'];
        } else {
            $data['email'] = '';
        }

        if(isset($this->session->data['ps_guest_telephone'])){
            $data['telephone'] = $this->session->data['ps_guest_telephone'];
        }else if (isset($this->session->data['guest']['telephone'])) {
            $data['telephone'] = $this->session->data['guest']['telephone'];
        } else {
            $data['telephone'] = '';
        }

        if (isset($this->session->data['guest']['fax'])) {
            $data['fax'] = $this->session->data['guest']['fax'];
        } else {
            $data['fax'] = '';
        }

        if (isset($this->session->data['payment_address']['company'])) {
            $data['company'] = $this->session->data['payment_address']['company'];
        } else {
            $data['company'] = '';
        }

        if (isset($this->session->data['payment_address']['company_taxno'])) {
            $data['company_taxno'] = $this->session->data['payment_address']['company_taxno'];
        } else {
            $data['company_taxno'] = '';
        }

        if (isset($this->session->data['payment_address']['company_taxadmin'])) {
            $data['company_taxadmin'] = $this->session->data['payment_address']['company_taxadmin'];
        } else {
            $data['company_taxadmin'] = '';
        }



        if(isset($this->session->data['ps_guest_payment_address_1'])){
            $data['address_1'] = $this->session->data['ps_guest_payment_address_1'];
        }else if (isset($this->session->data['payment_address']['address_1'])) {
            $data['address_1'] = $this->session->data['payment_address']['address_1'];
        } else {
            $data['address_1'] = '';
        }

        if (isset($this->session->data['payment_address']['address_2'])) {
            $data['address_2'] = $this->session->data['payment_address']['address_2'];
        } else {
            $data['address_2'] = '';
        }

        if (isset($this->session->data['payment_address']['postcode'])) {
            $data['postcode'] = $this->session->data['payment_address']['postcode'];
        } elseif (isset($this->session->data['shipping_address']['postcode'])) {
            $data['postcode'] = $this->session->data['shipping_address']['postcode'];
        } else {
            $data['postcode'] = '';
        }

        if(isset($this->session->data['ps_guest_payment_city'])){
            $data['city'] = $this->session->data['ps_guest_payment_city'];
        }else if (isset($this->session->data['payment_address']['city'])) {
            $data['city'] = $this->session->data['payment_address']['city'];
        } else {
            $data['city'] = '';
        }

        if(isset($this->session->data['ps_guest_payment_country_id'])){
            $data['country_id'] = $this->session->data['ps_guest_payment_country_id'];
        }else if (isset($this->session->data['payment_address']['country_id'])) {
            $data['country_id'] = $this->session->data['payment_address']['country_id'];
        } else if (isset($this->session->data['shipping_address']['country_id'])) {
            $data['country_id'] = $this->session->data['shipping_address']['country_id'];
        } else {
            $country = $this->config->get('quickcheckout_field_country');
            $data['country_id'] = isset($country['default']) ? $country['default'] : 0;
        }

        if(isset($this->session->data['ps_guest_payment_zone_id'])){
            $data['zone_id'] = $this->session->data['ps_guest_payment_zone_id'];
        }else if (isset($this->session->data['payment_address']['zone_id'])) {
            $data['zone_id'] = $this->session->data['payment_address']['zone_id'];
        } elseif (isset($this->session->data['shipping_address']['zone_id'])) {
            $data['zone_id'] = $this->session->data['shipping_address']['zone_id'];
        } else {
            $zone = $this->config->get('quickcheckout_field_zone');
            $data['zone_id'] = isset($zone['default']) ? $zone['default'] : 0;
        }

        $this->load->model('localisation/country');

        $data['countries'] = $this->model_localisation_country->getCountries();

        // Custom Fields
        $this->load->model('account/custom_field');

        $data['custom_fields'] = $this->model_account_custom_field->getCustomFields();

        if (isset($this->session->data['guest']['custom_field'])) {
            $data['guest_custom_field'] = $this->session->data['guest']['custom_field'] + $this->session->data['payment_address']['custom_field'];
        } else {
            $data['guest_custom_field'] = array();
        }

        $data['shipping_required'] = $this->cart->hasShipping();

        if (isset($this->session->data['guest']['shipping_address'])) {
            $data['shipping_address'] = $this->session->data['guest']['shipping_address'];
        } else {
            $data['shipping_address'] = true;
        }

        $field_register = $this->config->get('quickcheckout_field_register');

        if (isset($this->session->data['guest']['create_account'])) {
            $data['create_account'] = $this->session->data['guest']['create_account'];
        } elseif (!empty($field_register['default'])) {
            $data['create_account'] = true;
        } else {
            $data['create_account'] = false;
        }


        // Fields
        $fields = array(
            'firstname',
            'lastname',
            'email',
            'telephone',
            'fax',
            'company',
            'company_taxno',
            'company_taxadmin',
            'customer_group',
            'address_1',
            'address_2',
            'city',
            'postcode',
            'country',
            'zone'
        );

        // All variables
        $data['debug'] = $this->config->get('quickcheckout_debug');
        $data['field_register'] = $this->config->get('quickcheckout_field_register');

        $sort_order = array();

        foreach ($fields as $key => $field) {
            $field_data = $this->config->get('quickcheckout_field_' . $field);

            $field_data['default'] = !empty($field_data['default'][$this->config->get('config_language_id')]) ? $field_data['default'][$this->config->get('config_language_id')] : '';
            $field_data['placeholder'] = !empty($field_data['placeholder'][$this->config->get('config_language_id')]) ? $field_data['placeholder'][$this->config->get('config_language_id')] : '';

            $data['field_' . $field] = $field_data;

            $sort_order[$key] = $field_data['sort_order'];
        }

        array_multisort($sort_order, SORT_ASC, $fields);


        $data['fields'] = $fields;

        $data['register'] = $this->load->controller('quickcheckout/register');

        if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/quickcheckout/guest.tpl')){
            return $this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/quickcheckout/guest', $data);
        }else{
            return $this->load->view(DIR_TEMPLATE . 'default/template/quickcheckout/guest', $data);
        }




    }

    public function validate() {

        $this->load->language('checkout/checkout');
        $this->load->language('quickcheckout/checkout');

        $json = array();

        // Validate if customer is logged in.
        if ($this->customer->isLogged()) {
            $json['redirect'] = $this->url->link('quickcheckout/checkout', '', true);
        }

        if (!$json) {
            $firstname = $this->config->get('quickcheckout_field_firstname');

            if (!empty($firstname['required'])) {
                if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen($this->request->post['firstname']) > 32)) {
                    $json['error']['firstname'] = $this->language->get('error_firstname');
                }
            }

            $lastname = $this->config->get('quickcheckout_field_lastname');

            if (!empty($lastname['required'])) {
                if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen($this->request->post['lastname']) > 32)) {
                    $json['error']['lastname'] = $this->language->get('error_lastname');
                }
            }

            $email = $this->config->get('quickcheckout_field_email');

            if (!empty($email['required'])) {
                $this->request->post['email'] = trim($this->request->post['email']);
                if ((utf8_strlen($this->request->post['email']) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
                    $json['error']['email'] = $this->language->get('error_email');
                }
            } else {

                if (empty($this->request->post['email'])) {
                    $this->request->post['email'] = substr(uniqid('', true), -10) . '@example.com';
                } else {
                    if ((utf8_strlen($this->request->post['email']) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
                        $json['error']['email'] = $this->language->get('error_email');
                    }
                }
            }

            $telephone = $this->config->get('quickcheckout_field_telephone');

            if (!empty($telephone['required'])) {
                if ((utf8_strlen($this->request->post['telephone']) < 10) || (utf8_strlen($this->request->post['telephone']) > 10)) {
                    $json['error']['telephone'] = $this->language->get('error_telephone');
                }

                if(!is_numeric($this->request->post['telephone'])){
                    $json['error']['telephone'] = "Telefon bilgisi sayılardan oluşmalıdır";
                }

                $tel = $this->request->post['telephone'];
                if(isset($tel[0])){
                    if($tel[0] == '0'){
                        $json['error']['telephone'] = "Lütfen numaranızın başına 0 koymayınız!";
                    }
                }
            }

            $fax = $this->config->get('quickcheckout_field_fax');

            if (!empty($fax['required'])) {
                if ((utf8_strlen($this->request->post['fax']) < 3) || (utf8_strlen($this->request->post['fax']) > 32)) {
                    $json['error']['fax'] = $this->language->get('error_fax');
                }
            }

            //Kurumsal Fatura Bilgileri

            if(isset($this->request->post['payment_company_info'])){

                if ((utf8_strlen($this->request->post['company']) < 3) || (utf8_strlen($this->request->post['company']) > 200)) {
                    $json['error']['company'] = $this->language->get('error_company');
                }


                if ((utf8_strlen($this->request->post['company_taxno']) < 3) || (utf8_strlen($this->request->post['company_taxno']) > 32)) {
                    $json['error']['company_taxno'] = $this->language->get('error_company_taxno');
                }


                if ((utf8_strlen($this->request->post['company_taxadmin']) < 3) || (utf8_strlen($this->request->post['company_taxadmin']) > 50)) {
                    $json['error']['company_taxadmin'] = $this->language->get('error_company_taxadmin');
                }


            }


            //Kurumsal Fatura Bilgileri



            $address_1 = $this->config->get('quickcheckout_field_address_1');

            if (!empty($address_1['required'])) {
                if ((utf8_strlen($this->request->post['address_1']) < 3) || (utf8_strlen($this->request->post['address_1']) > 128)) {
                    $json['error']['address_1'] = $this->language->get('error_address_1');
                }
            }

            $address_2 = $this->config->get('quickcheckout_field_address_2');

            if (!empty($address_2['required'])) {
                if ((utf8_strlen($this->request->post['address_2']) < 3) || (utf8_strlen($this->request->post['address_2']) > 128)) {
                    $json['error']['address_2'] = $this->language->get('error_address_2');
                }
            }

            $city = $this->config->get('quickcheckout_field_city');

            if (!empty($city['required'])) {
                if (utf8_strlen($this->request->post['city']) < 1) {
                    $json['error']['city'] = $this->language->get('error_city');
                }
            }

            $this->load->model('localisation/country');

            $country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);


            $country = $this->config->get('quickcheckout_field_country');

            if (!empty($country['required'])) {
                if ($this->request->post['country_id'] == '') {
                    $json['error']['country'] = $this->language->get('error_country');
                }
            }

            $zone = $this->config->get('quickcheckout_field_zone');

            if (!empty($zone['required'])) {
                if ($this->request->post['zone_id'] == '') {
                    $json['error']['zone'] = $this->language->get('error_zone');
                }
            }

            // Customer Group
            if (isset($this->request->post['customer_group_id']) && is_array($this->config->get('config_customer_group_display')) && in_array($this->request->post['customer_group_id'], $this->config->get('config_customer_group_display'))) {
                $customer_group_id = $this->request->post['customer_group_id'];
            } else {
                $customer_group_id = $this->config->get('config_customer_group_id');
            }

            // Custom field validation
            $this->load->model('account/custom_field');

            $custom_fields = $this->model_account_custom_field->getCustomFields($customer_group_id);

            foreach ($custom_fields as $custom_field) {
                if ($custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['location']][$custom_field['custom_field_id']])) {
                    $json['error']['custom_field' . $custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                }
            }
        }

        if (!$json) {
            $validate_email = $this->db->query("SELECT email FROM ps_customer WHERE email = '" . trim($this->request->post['email']) . "' ");
            if ($validate_email->row) {
                $json['error']['email'] = $this->language->get('error_email_already_exist');
            }
        }

        if (!$json) {
            $this->session->data['account'] = 'guest';

            $this->session->data['guest']['customer_group_id'] = $customer_group_id;
            $this->session->data['guest']['firstname'] = $this->request->post['firstname'];
            $this->session->data['guest']['lastname'] = $this->request->post['lastname'];
            $this->session->data['guest']['email'] = $this->request->post['email'];
            $this->session->data['guest']['telephone'] = $this->request->post['telephone'];
            $this->session->data['guest']['fax'] = $this->request->post['fax'];

            if (isset($this->request->post['custom_field']['account'])) {
                $this->session->data['guest']['custom_field'] = $this->request->post['custom_field']['account'];
            } else {
                $this->session->data['guest']['custom_field'] = array();
            }

            $this->session->data['payment_address']['firstname'] = $this->request->post['firstname'];
            $this->session->data['payment_address']['lastname'] = $this->request->post['lastname'];
            $this->session->data['payment_address']['company'] = $this->request->post['company'];
            $this->session->data['payment_address']['company_taxno'] = $this->request->post['company_taxno'];
            $this->session->data['payment_address']['company_taxadmin'] = $this->request->post['company_taxadmin'];

            $this->session->data['payment_address']['address_1'] = $this->request->post['address_1'];
            $this->session->data['payment_address']['address_2'] = $this->request->post['address_2'];
            $this->session->data['payment_address']['postcode'] = $this->request->post['postcode'];
            $this->session->data['payment_address']['city'] = $this->request->post['city'];
            $this->session->data['payment_address']['country_id'] = $this->request->post['country_id'];
            $this->session->data['payment_address']['zone_id'] = $this->request->post['zone_id'];
            $this->session->data['payment_address']['zone_id'] = $this->request->post['zone_id'];

            $this->load->model('localisation/country');

            $country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);

            if ($country_info) {
                $this->session->data['payment_address']['country'] = $country_info['name'];
                $this->session->data['payment_address']['iso_code_2'] = $country_info['iso_code_2'];
                $this->session->data['payment_address']['iso_code_3'] = $country_info['iso_code_3'];
                $this->session->data['payment_address']['address_format'] = $country_info['address_format'];
            } else {
                $this->session->data['payment_address']['country'] = '';
                $this->session->data['payment_address']['iso_code_2'] = '';
                $this->session->data['payment_address']['iso_code_3'] = '';
                $this->session->data['payment_address']['address_format'] = '';
            }

            if (isset($this->request->post['custom_field']['address'])) {
                $this->session->data['payment_address']['custom_field'] = $this->request->post['custom_field']['address'];
            } else {
                $this->session->data['payment_address']['custom_field'] = array();
            }

            $this->load->model('localisation/zone');

            $zone_info = $this->model_localisation_zone->getZone($this->request->post['zone_id']);

            if ($zone_info) {
                $this->session->data['payment_address']['zone'] = $zone_info['name'];
                $this->session->data['payment_address']['zone_code'] = $zone_info['code'];
            } else {
                $this->session->data['payment_address']['zone'] = '';
                $this->session->data['payment_address']['zone_code'] = '';
            }

            $city_info = $this->model_localisation_zone->getCity($this->request->post['city']);

            if ($city_info) {
                $this->session->data['payment_address']['city'] = $city_info['district_name'];
            } else {
                $this->session->data['payment_address']['city'] = $this->request->post['city'];
            }

            if (!empty($this->request->post['shipping_address'])) {
                $this->session->data['guest']['shipping_address'] = $this->request->post['shipping_address'];
            } else {
                $this->session->data['guest']['shipping_address'] = false;
            }

            // Default Payment Address
            if ($this->session->data['guest']['shipping_address']) {
                $this->session->data['shipping_address']['firstname'] = $this->request->post['firstname'];
                $this->session->data['shipping_address']['lastname'] = $this->request->post['lastname'];
                $this->session->data['shipping_address']['company'] = $this->request->post['company'];
                $this->session->data['shipping_address']['address_1'] = $this->request->post['address_1'];
                $this->session->data['shipping_address']['address_2'] = $this->request->post['address_2'];
                $this->session->data['shipping_address']['postcode'] = $this->request->post['postcode'];
                $this->session->data['shipping_address']['city'] = $this->request->post['city'];
                $this->session->data['shipping_address']['country_id'] = $this->request->post['country_id'];
                $this->session->data['shipping_address']['zone_id'] = $this->request->post['zone_id'];

                if ($country_info) {
                    $this->session->data['shipping_address']['country'] = $country_info['name'];
                    $this->session->data['shipping_address']['iso_code_2'] = $country_info['iso_code_2'];
                    $this->session->data['shipping_address']['iso_code_3'] = $country_info['iso_code_3'];
                    $this->session->data['shipping_address']['address_format'] = $country_info['address_format'];
                } else {
                    $this->session->data['shipping_address']['country'] = '';
                    $this->session->data['shipping_address']['iso_code_2'] = '';
                    $this->session->data['shipping_address']['iso_code_3'] = '';
                    $this->session->data['shipping_address']['address_format'] = '';
                }

                if ($zone_info) {
                    $this->session->data['shipping_address']['zone'] = $zone_info['name'];
                    $this->session->data['shipping_address']['zone_code'] = $zone_info['code'];
                } else {
                    $this->session->data['shipping_address']['zone'] = '';
                    $this->session->data['shipping_address']['zone_code'] = '';
                }

                if ($city_info) {
                    $this->session->data['shipping_address']['city'] = $city_info['district_name'];
                } else {
                    $this->session->data['shipping_address']['city'] = $this->request->post['city'];
                }



                if (isset($this->request->post['custom_field']['address'])) {
                    $this->session->data['shipping_address']['custom_field'] = $this->request->post['custom_field']['address'];
                } else {
                    $this->session->data['shipping_address']['custom_field'] = array();
                }
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
}