<?php
class ControllerCommonHome extends Controller {
	public function index() {

        $createCache = false;
        $cacheDir = 'home_page';
        $cacheFile = 'home';


        if (file_exists(DIR_CACHE . $cacheDir.'/' . $cacheFile . '.tpl')) {
            $this->response->setOutput($this->load->view( DIR_CACHE . $cacheDir.'/' . $cacheFile));
            return;
        }else {
            $createCache = true;
        }


		$data['config_meta_title'] = $this->config->get('config_meta_title');
		$data['config_meta_keyword'] = $this->config->get('config_meta_keyword');
		$data['config_meta_description'] = $this->config->get('config_meta_description');
		$this->session->data['proute'] = 'common/home';

		 if(isset($data['config_meta_title'][(int)$this->config->get('config_language_id')])){
		     $this->document->setTitle($data['config_meta_title'][(int)$this->config->get('config_language_id')]);
		 }else{
		     $this->document->setTitle($this->config->get('config_meta_title'));
		 }

		 if(isset($data['config_meta_description'][(int)$this->config->get('config_language_id')])){
		     $this->document->setDescription($data['config_meta_description'][(int)$this->config->get('config_language_id')]);
		 }else{
		     $this->document->setDescription($this->config->get('config_meta_description'));
		 }

		if(isset($data['config_meta_keyword'][(int)$this->config->get('config_language_id')])){
		    $this->document->setKeywords($data['config_meta_keyword'][(int)$this->config->get('config_language_id')]);
		}else{
		    $this->document->setKeywords($this->config->get('config_meta_keyword'));
		}


		if (isset($this->request->get['route'])) {
			$this->document->addLink($this->config->get('config_url'), 'canonical', true);
		}else{
			$this->document->addLink($this->config->get('config_ssl'), 'canonical', true);
		}

	//	$data['instashop'] = $this->load->controller('common/instashop');
		
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

		//dataLayer
        if (isset($this->session->data['customer_id']) && !empty($this->session->data['customer_id'])) {
            $data['dataLayer']['customer_id'] = $this->session->data['customer_id'];
            $data['dataLayer']['userType'] = 'member';

            $this->load->model('account/customer');

            $customerData = $this->model_account_customer->getCustomer($data['dataLayer']['customer_id']);
            $data['dataLayer']['emailHash'] = sha1($customerData['email']);

        }
        else {
            if (isset($_COOKIE['guest_id']) && !empty($_COOKIE['guest_id'])) {
                $guestId = $_COOKIE['guest_id'];
            }
            else {
                $guestId = rand(500000,999999);
                setcookie('guest_id', $guestId,time()+60*60*24*30, '/');
            }
            
            $data['dataLayer']['customer_id'] = $guestId;
            $data['dataLayer']['userType'] = 'guest';
            $data['dataLayer']['emailHash'] = '';
        }
	
		$data['CretioOneTag_status']=	$this->config->get('CretioOneTag_status');
        $data['CretioOneTag_id']=	$this->config->get('CretioOneTag_id');

        if ($createCache) {

            if (!file_exists(DIR_CACHE . $cacheDir)) {
                mkdir(DIR_CACHE . $cacheDir);
            }

            file_put_contents(DIR_CACHE . $cacheDir.'/' . $cacheFile . '.tpl',
                $this->load->view(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/common/home' , $data));

        }

		$this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/common/home', $data));

		
	}

}