<?php

class ControllerProductCategory extends Controller {

    public function index() {

        if ($this->request->server['HTTPS']) {
            $config_url = $this->config->get('config_ssl') . 'image/';
        } else {
            $config_url = $this->config->get('config_url') . 'image/';
        }

        $this->load->language('product/category');
        $this->load->model('catalog/category');
        $this->load->model('catalog/product');
        $this->load->model('tool/image');

        if (isset($this->request->get['filter'])) {
            $filter = $this->request->get['filter'];
        } else {
            $filter = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'p.sort_order';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['limit'])) {
            $limit = (int) $this->request->get['limit'];
        } else {
            $limit = $this->config->get($this->config->get('config_theme') . '_product_limit');
        }

        /* MARKA FILTRESI 04/05/2018 BILAL */
        if (isset($this->request->get['brand'])) {
            $f_brand = '';
            $qbrand = explode(',', $this->request->get['brand']);
            $qbrand = array_unique($qbrand);

            foreach ($qbrand as $qbk => $brn) {
                $f_brand .= ',' . $brn;
            }
        } else {
            $f_brand = '';
        }
        /* MARKA FILTRESI 04/05/2018 BILAL */

        /* SEÇENEK FILTRESI 04/05/2018 BILAL */
        if (isset($this->request->get['option'])) {
            $f_option = '';
            $qoption = explode(',', $this->request->get['option']);
            $qoption = array_unique($qoption);
            foreach ($qoption as $qopt) {
                $f_option .= ',' . $qopt;
            }
        } else {
            $f_option = '';
        }

        /* SEÇENEK FILTRESI 04/05/2018 BILAL */

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        if (isset($this->request->get['path'])) {
            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['limit'])) {
                $url .= '&limit=' . $this->request->get['limit'];
            }

            if (isset($this->request->get['brand'])) {
                $url .= '&brand=' . $this->request->get['brand'];
            }

            if (isset($this->request->get['option'])) {
                $url .= '&option=' . $this->request->get['option'];
            }

            $path = '';

            $parts = explode('_', (string) $this->request->get['path']);

            $category_id = (int) array_pop($parts);

            foreach ($parts as $path_id) {
                if (!$path) {
                    $path = (int) $path_id;
                } else {
                    $path .= '_' . (int) $path_id;
                }

                $category_info = $this->model_catalog_category->getCategory($path_id);

                if ($category_info) {
                    $data['breadcrumbs'][] = array(
                        'text' => $category_info['name'],
                        'href' => $this->url->link('product/category', 'path=' . $path . $url)
                    );
                }
            }
        } else {
            $category_id = 0;
        }

        $all_categories = $this->model_catalog_category->getCategories();
        $data['all_categories'] = array();
        foreach ($all_categories as $category) {
            $data['all_categories'][] = array(
                'name' => $category['name'],
                'category_id' => $category['category_id'],
                'href' => $this->url->link('product/category', 'path=' . $category['category_id'], true)
            );
        }

        $data['category_id'] = $this->model_catalog_category->getTopCategoryByCategoryId($category_id);
        //Seçilen kategorinin üst kategorilerini getirir.

        $sub_categories = $this->model_catalog_category->getCategories($data['category_id']);
        $data['sub_categories'] = array();
        foreach ($sub_categories as $category) {
            $data['sub_categories'][] = array(
                'name' => $category['name'],
                'category_id' => $category['category_id'],
                'href' => $this->url->link('product/category', 'path=' . $category['category_id'], true)
            );
        }

        $data['sub_category_id'] = $category_id;

        $sub_categories2 = $this->model_catalog_category->getCategories($data['sub_category_id']);

        $data['sub_categories2'] = array();
        foreach ($sub_categories2 as $category) {
            $data['sub_categories2'][] = array(
                'name' => $category['name'],
                'category_id' => $category['category_id'],
                'href' => $this->url->link('product/category', 'path=' . $category['category_id'], true)
            );
        }

        $data['sub_category_id2'] = $category_id;



        $this->session->data['category_id'] = $category_id;

        $category_info = $this->model_catalog_category->getCategory($category_id);

        $route = 'product/category';
        $path = 'path=' . $this->request->get['path'];

        if ($category_info) {

            $category_list = $this->model_catalog_category->getCategories($category_id);

            $data['category_list'] = array();
            foreach ($category_list as $list_item) { //var_dump($list_item); die();
                if ($list_item['image']) {
                    $thumb = $this->model_tool_image->resize($list_item['image'], $this->config->get($this->config->get('config_theme') . '_image_category_width'), $this->config->get($this->config->get('config_theme') . '_image_category_height'));
                } else {
                    $thumb = '';
                }

                if ($list_item['banner']) {
                    $banner = $this->model_tool_image->resize($list_item['banner'], 550, 393);
                } else {
                    $banner = '';
                }

                $bs_products = $this->model_catalog_category->getBestSellerProductsByCategory($list_item['category_id']);

                $best_seller_products = array();
                foreach ($bs_products as $bs_product) {
                    if ($bs_product['image']) {
                        $bs_image = $this->model_tool_image->resize($bs_product['image'], $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height'), 'product_list');
                    } else {
                        $bs_image = $this->model_tool_image->resize('placeholder.png', $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height'));
                    }

                    if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                        $bs_price = $this->currency->format($this->tax->calculate($bs_product['price'], $bs_product['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $bs_price = false;
                    }

                    if ((float) $bs_product['special']) {
                        $bs_special = $this->currency->format($this->tax->calculate($bs_product['special'], $bs_product['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $bs_special = false;
                    }

                    $best_seller_products[] = array(
                        'product_id' => $bs_product['product_id'],
                        'model' => $bs_product['model'],
                        'product_type' => $bs_product['product_type'],
                        'thumb' => $bs_image,
                        'quantity' => $bs_product['quantity'],
                        'name' => $bs_product['name'],
                        'price' => $bs_price,
                        'special' => $bs_special,
                        'percentsaving' => $bs_product['special'] ? round((($bs_product['price'] - $bs_product['special']) / $bs_product['price']) * 100, 0) : '',
                        'href' => $this->url->link('product/product', 'product_id=' . $bs_product['product_id']),
                    );
                }

                $data['category_list'][] = array(
                    'thumb' => $thumb,
                    'banner' => $banner,
                    'name' => $list_item['name'],
                    'description' => html_entity_decode($list_item['description'], ENT_QUOTES, 'UTF-8'),
                    'href' => $this->url->link('product/category', 'path=' . $list_item['category_id']),
                    'products' => $best_seller_products
                );
            }



            $this->document->setTitle($category_info['meta_title']);
            $this->document->setDescription($category_info['meta_description']);
            $this->document->setKeywords($category_info['meta_keyword']);

            $data['heading_title'] = $category_info['name'];

            $data['text_refine'] = $this->language->get('text_refine');
            $data['text_empty'] = $this->language->get('text_empty');
            $data['text_quantity'] = $this->language->get('text_quantity');
            $data['text_manufacturer'] = $this->language->get('text_manufacturer');
            $data['text_model'] = $this->language->get('text_model');
            $data['text_price'] = $this->language->get('text_price');
            $data['text_tax'] = $this->language->get('text_tax');
            $data['text_points'] = $this->language->get('text_points');
            $data['text_compare'] = sprintf($this->language->get('text_compare'), (isset($this->session->data['compare']) ? count($this->session->data['compare']) : 0));
            $data['text_sort'] = $this->language->get('text_sort');
            $data['text_default'] = $this->language->get('text_default');
            $data['text_limit'] = $this->language->get('text_limit');
            $data['text_filter'] = $this->language->get('text_filter');

            $data['text_f_category'] = $this->language->get('text_f_category');
            $data['text_f_brand'] = $this->language->get('text_f_brand');
            $data['text_f_option'] = $this->language->get('text_f_option');
            $data['text_f_attribure'] = $this->language->get('text_f_attribure');
            $data['text_order_private'] = $this->language->get('text_order_private');
            $data['text_order_critical'] = $this->language->get('text_order_critical');
            $data['text_bestsaller'] = $this->language->get('text_bestsaller');
            $data['text_bestview'] = $this->language->get('text_bestview');
            $data['text_in_stock'] = $this->language->get('text_in_stock');
            $data['text_order_in_stock'] = $this->language->get('text_order_in_stock');

            $data['button_cart'] = $this->language->get('button_cart');
            $data['button_wishlist'] = $this->language->get('button_wishlist');
            $data['button_compare'] = $this->language->get('button_compare');
            $data['button_continue'] = $this->language->get('button_continue');
            $data['button_list'] = $this->language->get('button_list');
            $data['button_grid'] = $this->language->get('button_grid');
            $data['quick_view'] = $this->language->get('quick_view');

            $data['text_discount'] = $this->language->get('text_discount');
            $data['text_view'] = $this->language->get('text_view');
            $data['text_quick_view'] = $this->language->get('text_quick_view');
            $data['text_no_stock'] = $this->language->get('text_no_stock');
            $data['text_product_done'] = $this->language->get('text_product_done');



            // Set the last category breadcrumb
            $data['breadcrumbs'][] = array(
                'text' => $category_info['name'],
                'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'])
            );

            if ($category_info['image']) {
                $data['thumb'] = $this->model_tool_image->resize($category_info['image'], $this->config->get($this->config->get('config_theme') . '_image_category_width'), $this->config->get($this->config->get('config_theme') . '_image_category_height'));
            } else {
                $data['thumb'] = '';
            }

            if ($category_info['banner']) {
                $data['banner'] = $this->model_tool_image->resize($category_info['banner'], $this->config->get($this->config->get('config_theme') . '_image_category_width'), $this->config->get($this->config->get('config_theme') . '_image_category_height'));
            } else {
                $data['banner'] = '';
            }

            $data['show_products'] = $category_info['show_products'];

            $this->document->setFBog($data['thumb']);

            $data['description'] = html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');
            $data['compare'] = $this->url->link('product/compare');

            $url = '';

            if (isset($this->request->get['filter'])) {
                $url .= '&filter=' . $this->request->get['filter'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['limit'])) {
                $url .= '&limit=' . $this->request->get['limit'];
            }

            if (isset($this->request->get['brand'])) {
                $url .= '&brand=' . $this->request->get['brand'];
            }

            if (isset($this->request->get['option'])) {
                $url .= '&option=' . $this->request->get['option'];
            }


            $parts = explode('_', (string) $this->request->get['path']);

            if (isset($parts[0])) {
                $data['category_id'] = $parts[0];
            } else {
                $data['category_id'] = 0;
            }

            $data['category_names'] = array();


            $data['categories'] = array();


            $data['products'] = array();

            $filter_data = array(
                'filter_category_id' => $category_id,
                'filter_sub_category' => $this->config->get('config_subcategory_show'),
                'filter_filter' => $filter,
                'sort' => $sort,
                'order' => $order,
                'start' => ($page - 1) * $limit,
                'limit' => $limit,
                'brand' => $f_brand,
                'option' => $f_option,
                'product_showcase' => 1,
            );

            $product_total = 0;
            $results = array();


            $url = '';

            if (isset($this->request->get['filter'])) {
                $url .= '&filter=' . $this->request->get['filter'];
            }

            if (isset($this->request->get['limit'])) {
                $url .= '&limit=' . $this->request->get['limit'];
            }

            $data['sorts'] = array();

            $data['sorts'][] = array(
                'text' => $this->language->get('text_default'),
                'value' => 'p.sort_order-ASC',
                'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.sort_order&order=ASC' . $url)
            );

            $data['sorts'][] = array(
                'text' => $this->language->get('text_name_asc'),
                'value' => 'pd.name-ASC',
                'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=ASC' . $url)
            );

            $data['sorts'][] = array(
                'text' => $this->language->get('text_name_desc'),
                'value' => 'pd.name-DESC',
                'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=pd.name&order=DESC' . $url)
            );

            $data['sorts'][] = array(
                'text' => $this->language->get('text_price_asc'),
                'value' => 'p.price-ASC',
                'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=ASC' . $url)
            );

            $data['sorts'][] = array(
                'text' => $this->language->get('text_price_desc'),
                'value' => 'p.price-DESC',
                'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.price&order=DESC' . $url)
            );

            if ($this->config->get('config_review_status')) {
                $data['sorts'][] = array(
                    'text' => $this->language->get('text_rating_desc'),
                    'value' => 'rating-DESC',
                    'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=DESC' . $url)
                );

                $data['sorts'][] = array(
                    'text' => $this->language->get('text_rating_asc'),
                    'value' => 'rating-ASC',
                    'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=rating&order=ASC' . $url)
                );
            }

            $data['sorts'][] = array(
                'text' => $this->language->get('text_model_asc'),
                'value' => 'p.model-ASC',
                'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=ASC' . $url)
            );

            $data['sorts'][] = array(
                'text' => $this->language->get('text_model_desc'),
                'value' => 'p.model-DESC',
                'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . '&sort=p.model&order=DESC' . $url)
            );


            /* MARKA FILTRESI 04/05/2018 BILAL */
            /* SEÇİLEN MARKALARI BULUYORUZ */
            $data['selected_brands'] = array();
            $data['f_brand_list'] = array();
            if (!empty($f_brand)) {

                $fd_list = array(); //filtre delete list
                $f_brand_list = explode(',', $f_brand);
                unset($f_brand_list[0]);

                $data['selected_brands'] = $f_brand_list;

                foreach ($f_brand_list as $bkey => $blist) {
                    foreach ($brands as $brand) {
                        if ($blist == $brand['manufacturer_id']) {

                            $fd_list = $f_brand_list; //filtre delete list
                            $nf_brand = ''; //new brand list
                            foreach ($fd_list as $fdl) {
                                if ($fdl != $blist) {
                                    $nf_brand .= $fdl . ',';
                                }
                            }

                            if ($nf_brand) {
                                $data['f_brand_list'][] = array(
                                    'name' => $brand['name'],
                                    'href' => $this->url->link($route, $path . $url . '&brand=' . rtrim($nf_brand, ',')),
                                );
                            } else {
                                $data['f_brand_list'][] = array(
                                    'name' => $brand['name'],
                                    'href' => $this->url->link($route, $path . $url),
                                );
                            }
                        }
                    }
                }
            }

            /* MARKA FILTRESI 04/05/2018 BILAL */


            /* SEÇENEK FILTRESI 07/05/2018 BİLAL */

            $data['f_option_list'] = array();
            $data['selected_options'] = array();
            if (!empty($f_option)) {
                $fd_list = array(); //filtre delete list
                $f_otption_list = explode(',', $f_option); // filtre option list
                unset($f_otption_list[0]);
                $data['selected_options'] = $f_otption_list;

                foreach ($f_otption_list as $folist) {
                    foreach ($option_value_list as $ovlist) {
                        if ($folist == $ovlist['ov_option_id']) {

                            $fd_list = $f_otption_list; //filtre delete list
                            $nf_brand = ''; //new brand list
                            foreach ($fd_list as $fdl) {
                                if ($fdl != $folist) {
                                    $nf_brand .= $fdl . ',';
                                }
                            }

                            if ($nf_brand) {
                                $data['f_option_list'][] = array(
                                    'name' => $ovlist['ov_name'],
                                    'href' => $this->url->link($route, $path . $url . '&option=' . rtrim($nf_brand, ',')),
                                );
                            } else {
                                $data['f_option_list'][] = array(
                                    'name' => $ovlist['ov_name'],
                                    'href' => $this->url->link($route, $path . $url),
                                );
                            }
                        }
                    }
                }
            }
            /* SEÇENEK FILTRESI 07/05/2018 BİLAL */

            $url = '';

            if (isset($this->request->get['filter'])) {
                $url .= '&filter=' . $this->request->get['filter'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['brand'])) {
                $url .= '&brand=' . $this->request->get['brand'];
            }

            if (isset($this->request->get['option'])) {
                $url .= '&option=' . $this->request->get['option'];
            }

            $data['limits'] = array();

            $limits = array_unique(array($this->config->get($this->config->get('config_theme') . '_product_limit'), 25, 50, 75, 100));

            sort($limits);

            foreach ($limits as $value) {
                $data['limits'][] = array(
                    'text' => $value,
                    'value' => $value,
                    'href' => $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&limit=' . $value)
                );
            }

            $url = '';

            if (isset($this->request->get['filter'])) {
                $url .= '&filter=' . $this->request->get['filter'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['limit'])) {
                $url .= '&limit=' . $this->request->get['limit'];
            }

            if (isset($this->request->get['brand'])) {
                $url .= '&brand=' . $this->request->get['brand'];
            }

            if (isset($this->request->get['option'])) {
                $url .= '&option=' . $this->request->get['option'];
            }

            $pagination = new Pagination();
            $pagination->total = $product_total;
            $pagination->page = $page;
            $pagination->limit = $limit;
            $pagination->url = $this->url->link('product/category', 'path=' . $this->request->get['path'] . $url . '&page={page}');

            $data['pagination'] = $pagination->render();

            $data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($product_total - $limit)) ? $product_total : ((($page - 1) * $limit) + $limit), $product_total, ceil($product_total / $limit));

            if ($page == 1) {
                $this->document->addLink($this->url->link('product/category', 'path=' . $category_info['category_id'], true), 'canonical');
            } elseif ($page == 2) {
                $this->document->addLink($this->url->link('product/category', 'path=' . $category_info['category_id'], true), 'prev');
            } else {
                $this->document->addLink($this->url->link('product/category', 'path=' . $category_info['category_id'] . '&page=' . ($page - 1), true), 'prev');
            }

            if ($limit && ceil($product_total / $limit) > $page) {
                $this->document->addLink($this->url->link('product/category', 'path=' . $category_info['category_id'] . '&page=' . ($page + 1), true), 'next');
            }

            $data['sort'] = $sort;
            $data['order'] = $order;
            $data['limit'] = $limit;

            $data['continue'] = $this->url->link('common/home');

            $data['column_left'] = $this->load->controller('common/column_left');
            $data['column_right'] = $this->load->controller('common/column_right');
            $data['content_top'] = $this->load->controller('common/content_top');
            $data['content_bottom'] = $this->load->controller('common/content_bottom');
           
            $data['footer'] = $this->cache->get('category_footer');
 if (!$data['footer']) {
                $data['footer'] = $this->load->controller('common/footer');
                $this->cache->set('category_footer', $data['footer']);
            }



            $data['header'] = $this->cache->get('category_header');
            if (!$data['header']) {
                $data['header'] = $this->load->controller('common/header');
                $this->cache->set('category_header', $data['header']);
            }
            if (file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/product/category.tpl')) {
                $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/product/category', $data));
            } else {
                $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/product/category', $data));
            }
        } else {
            $url = '';

            if (isset($this->request->get['path'])) {
                $url .= '&path=' . $this->request->get['path'];
            }

            if (isset($this->request->get['filter'])) {
                $url .= '&filter=' . $this->request->get['filter'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if (isset($this->request->get['limit'])) {
                $url .= '&limit=' . $this->request->get['limit'];
            }

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_error'),
                'href' => $this->url->link('product/category', $url)
            );

            $this->document->setTitle($this->language->get('text_error'));

            $data['heading_title'] = $this->language->get('text_error');

            $data['text_error'] = $this->language->get('text_error');

            $data['button_continue'] = $this->language->get('button_continue');

            $data['continue'] = $this->url->link('common/home');

            $this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . ' 404 Not Found');

            $data['column_left'] = $this->load->controller('common/column_left');
            $data['column_right'] = $this->load->controller('common/column_right');
            $data['content_top'] = $this->load->controller('common/content_top');
            $data['content_bottom'] = $this->load->controller('common/content_bottom');
            $data['footer'] = $this->load->controller('common/footer');
            $data['header'] = $this->load->controller('common/header');

            if (file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/error/not_found.tpl')) {
                $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/error/not_found', $data));
            } else {
                $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'error/not_found', $data));
            }
        }
    }

    private function exportFilterElement($elements) {
        if (isset($elements) and $elements) {
            $dizi = array();
            $elements = explode('-', $elements);
            foreach ($elements as $key => $value) {
                if ($value) {
                    $dizi[] = $value;
                }
            }

            return array_unique($dizi);
        } else {
            return false;
        }
    }

    private function removeFilterElement($element, $elements = array()) {
        if ($element and $elements) {
            $string = '';
            foreach ($elements as $key => $value) {
                if ($value != $element) {
                    $string .= $value . '-';
                }
            }
            $string = rtrim($string, '-');
            return $string ? $string : false;
        } else {
            return false;
        }
    }

    private function getSearchText() {

        if (isset($this->session->data['search']) and $this->session->data['search']) {
            return '&search=' . $this->session->data['search'];
        }
    }

    public function getBrandsIds() {
        $brands_ids = '';
        $i = 0;
        if (isset($this->session->data['filter_brand']) and $this->session->data['filter_brand']) {
            foreach ($this->session->data['filter_brand'] as $brand) {
                if ($brand != '') {
                    $i++;
                    $brands_ids .= $brand . '-';
                }
            }
        } else {
            return '&brand=';
        }

        return ($i > 0) ? '&brand=' . $brands_ids : '';
    }

    public function getAttributesIds() {
        $attributes_ids = '';
        $i = 0;
        if (isset($this->session->data['filter_attribute']) and $this->session->data['filter_attribute']) {
            foreach ($this->session->data['filter_attribute'] as $attribute) {
                if ($attribute != '') {
                    $i++;
                    $attributes_ids .= $attribute . '-';
                }
            }
        } else {
            return '&attribute=';
        }
        return ($i > 0) ? '&attribute=' . $attributes_ids : '';
    }

    public function getOptionsIds() {
        $options_ids = '';
        $i = 0;
        if (isset($this->session->data['filter_option']) and $this->session->data['filter_option']) {
            foreach ($this->session->data['filter_option'] as $option) {
                if ($option != '') {
                    $i++;
                    $options_ids .= $option . '-';
                }
            }
        } else {
            return '&option=';
        }
        return ($i > 0) ? '&option=' . $options_ids : '';
    }

    public function getSubCategories() {

        $data['categories'] = array();

        if (isset($this->request->post['category_id'])) {
            $category_id = $this->request->post['category_id'];

            $this->load->model('catalog/category');
            $this->load->model('catalog/product');
            $this->load->model('tool/image');
            $categories = $this->model_catalog_category->getCategories($category_id);

            foreach ($categories as $result) {

                $filter_data = array(
                    'filter_category_id' => $result['category_id'],
                    'filter_sub_category' => true
                );

                $data['categories'][] = array(
                    'name' => $result['name'] . ($this->config->get('config_product_count') ? ' (' . $this->model_catalog_product->getTotalProducts($filter_data) . ')' : ''),
                    'href' => $this->url->link('product/category', 'path=' . $category_id . '_' . $result['category_id']),
                    'category_id' => $result['category_id'],
                    'image' => $result['image'] ? $this->model_tool_image->resize($result['image'], $this->config->get($this->config->get('config_theme') . '_image_cart_width'), $this->config->get($this->config->get('config_theme') . '_image_cart_height')) : false,
                );
            }
        }


        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));
    }

    public function getBrandsJSON() {
        $path = $this->session->data['path'];
        $this->load->model('catalog/product');
        $brand_filter_data = array(
            'category_id' => $this->session->data['category_id'],
            'filter_attribute' => isset($this->session->data['filter_attribute']) ? $this->session->data['filter_attribute'] : false,
            'filter_option' => isset($this->session->data['filter_option']) ? $this->session->data['filter_option'] : false,
        );
        $brands = $this->model_catalog_product->getBrands($brand_filter_data);
        $data['f_brand_list'] = array();
        $data['brands'] = array();
        foreach ($brands as $brand) {
            $data['brands'][] = array(
                'manufacturer_id' => $brand['manufacturer_id'],
                'name' => $brand['name'],
                'href' => $path . $this->getBrandsIds() . $brand['manufacturer_id'] . $this->getAttributesIds() . $this->getOptionsIds() . $this->getSearchText(),
            );
            if (isset($this->session->data['filter_brand']) and $this->session->data['filter_brand']) {
                if (in_array($brand['manufacturer_id'], $this->session->data['filter_brand'])) {
                    $data['f_brand_list'][] = array(
                        'name' => $brand['name'],
                        'href' => $path . ($this->removeFilterElement($brand['manufacturer_id'], $this->session->data['filter_brand']) ? '&brand=' . $this->removeFilterElement($brand['manufacturer_id'], $this->session->data['filter_brand']) : '') . $this->getAttributesIds() . $this->getOptionsIds() . $this->getSearchText(),
                    );
                }
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));
    }

    public function getAttributesJSON() {

        $path = $this->session->data['path'];
        $this->load->model('catalog/product');
        $attribute_filter_data = array(
            'category_id' => $this->session->data['category_id'],
            'filter_attribute' => isset($this->session->data['filter_attribute']) ? $this->session->data['filter_attribute'] : false,
            'filter_option' => isset($this->session->data['filter_option']) ? $this->session->data['filter_option'] : false,
            'filter_brand' => isset($this->session->data['filter_brand']) ? $this->session->data['filter_brand'] : false,
        );
        $data['f_attribute_list'] = array();
        $data['attributes'] = array();
        $attribute_groups = $this->model_catalog_product->getAttributeGroups($attribute_filter_data);
        foreach ($attribute_groups as $key => $attribute_group) {
            $attributes = $this->model_catalog_product->getAttributeValues($attribute_group['attribute_group_id'], $attribute_filter_data);
            $attribute_values = array();
            foreach ($attributes as $attribute) {
                $attribute_values[] = array(
                    'attribute_id' => $attribute['attribute_id'],
                    'name' => $attribute['name'],
                    'href' => $path . $this->getBrandsIds() . $this->getAttributesIds() . $attribute['attribute_id'] . $this->getOptionsIds() . $this->getSearchText(),
                );
                if (isset($this->session->data['filter_attribute']) and $this->session->data['filter_attribute']) {
                    if (in_array($attribute['attribute_id'], $this->session->data['filter_attribute'])) {
                        $data['f_attribute_list'][] = array(
                            'name' => $attribute['name'],
                            'href' => $path . $this->getBrandsIds() . ($this->removeFilterElement($attribute['attribute_id'], $this->session->data['filter_attribute']) ? '&attribute=' . $this->removeFilterElement($attribute['attribute_id'], $this->session->data['filter_attribute']) : '') . $this->getOptionsIds() . $this->getSearchText(),
                        );
                    }
                }
            }
            $data['attributes'][] = array(
                'attribute_group_id' => $attribute_group['attribute_group_id'],
                'name' => $attribute_group['name'],
                'attribute_values' => $attribute_values,
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));
    }

    public function getOptionsJSON() {
        $path = $this->session->data['path'];
        $this->load->model('catalog/product');
        $option_filter_data = array(
            'category_id' => $this->session->data['category_id'],
            'filter_option' => isset($this->session->data['filter_option']) ? $this->session->data['filter_option'] : false,
            'filter_attribute' => isset($this->session->data['filter_attribute']) ? $this->session->data['filter_attribute'] : false,
            'filter_brand' => isset($this->session->data['filter_brand']) ? $this->session->data['filter_brand'] : false,
        );

        $options = $this->model_catalog_product->getOptions($option_filter_data);
        $data['f_option_list'] = array();
        $data['options'] = array();
        foreach ($options as $option) {
            $option_values = array();
            $get_option_values = $this->model_catalog_product->getOptionValues($option['option_id'], $option_filter_data);
            foreach ($get_option_values as $option_value) {
                $option_values[] = array(
                    'ov_option_id' => $option_value['ov_option_id'],
                    'name' => $option_value['name'],
                    'href' => $path . $this->getBrandsIds() . $this->getAttributesIds() . $this->getOptionsIds() . $option_value['ov_option_id'] . $this->getSearchText(),
                );

                if (isset($this->session->data['filter_option']) and $this->session->data['filter_option']) {
                    if (in_array($option_value['ov_option_id'], $this->session->data['filter_option'])) {
                        $data['f_option_list'][] = array(
                            'name' => $option_value['name'],
                            'href' => $path . $this->getBrandsIds() . $this->getAttributesIds() . ($this->removeFilterElement($option_value['ov_option_id'], $this->session->data['filter_option']) ? '&option=' . $this->removeFilterElement($option_value['ov_option_id'], $this->session->data['filter_option']) : '') . $this->getSearchText(),
                        );
                    }
                }
            }
            $data['options'][] = array(
                'option_id' => $option['option_id'],
                'name' => $option['name'],
                'option_values' => $option_values
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));

        //getOptions
    }

    public function getSortsJSON() {

        $path = $this->session->data['path'] . $this->getBrandsIds() . $this->getAttributesIds() . $this->getOptionsIds() . $this->getSearchText();
        $this->load->language('product/category');

        $data['sorts'] = array();
        $data['sorts'][] = array(
            'text' => $this->language->get('text_default'),
            'value' => 'p.sort_order-ASC',
            'href' => $path . '&sort=p.sort_order&order=ASC',
        );

        $data['sorts'][] = array(
            'text' => $this->language->get('text_name_asc'),
            'value' => '&sort=pd.name&order=ASC',
            'href' => $path . '&sort=pd.name&order=ASC'
        );

        $data['sorts'][] = array(
            'text' => $this->language->get('text_name_desc'),
            'value' => '&sort=pd.name&order=DESC',
            'href' => $path . '&sort=pd.name&order=DESC'
        );

        $data['sorts'][] = array(
            'text' => $this->language->get('text_price_asc'),
            'value' => '&sort=p.price&order=ASC',
            'href' => $path . '&sort=p.price&order=ASC'
        );

        $data['sorts'][] = array(
            'text' => $this->language->get('text_price_desc'),
            'value' => '&sort=p.price&order=DESC',
            'href' => $path . '&sort=p.price&order=DESC'
        );

        if ($this->config->get('config_review_status')) {
            $data['sorts'][] = array(
                'text' => $this->language->get('text_rating_desc'),
                'value' => '&sort=rating&order=DESC',
                'href' => $path . '&sort=rating&order=DESC'
            );

            $data['sorts'][] = array(
                'text' => $this->language->get('text_rating_asc'),
                'value' => '&sort=rating&order=ASC',
                'href' => $path . '&sort=rating&order=ASC'
            );
        }

        $data['sorts'][] = array(
            'text' => $this->language->get('text_model_asc'),
            'value' => '&sort=p.model&order=ASC',
            'href' => $path . '&sort=p.model&order=ASC'
        );

        $data['sorts'][] = array(
            'text' => $this->language->get('text_model_desc'),
            'value' => '&sort=p.model&order=DESC',
            'href' => $path . '&sort=p.model&order=DESC'
        );

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));
    }

    public function createcache() {

        $this->load->model('catalog/category');
        $this->model_catalog_category->createCache();
    }

    public function showproducts() {
        $json = array();
        if ($this->request->server['HTTPS']) {
            $config_url = $this->config->get('config_ssl') . 'image/';
        } else {
            $config_url = $this->config->get('config_url') . 'image/';
        }

        $this->load->language('product/category');
        $this->load->model('catalog/category');
        $this->load->model('catalog/product');
        $this->load->model('tool/image');

        if (isset($this->request->get['filter'])) {
            $filter = $this->request->get['filter'];
        } else {
            $filter = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'p.sort_order';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['limit'])) {
            $limit = (int) $this->request->get['limit'];
        } else {
            $limit = $this->config->get($this->config->get('config_theme') . '_product_limit');
        }

        if (isset($this->request->get['brand'])) {
            $f_brand = '';
            $qbrand = explode(',', $this->request->get['brand']);
            $qbrand = array_unique($qbrand);

            foreach ($qbrand as $qbk => $brn) {
                $f_brand .= ',' . $brn;
            }
        } else {
            $f_brand = '';
        }

        if (isset($this->request->get['option'])) {
            $f_option = '';
            $qoption = explode(',', $this->request->get['option']);
            $qoption = array_unique($qoption);
            foreach ($qoption as $qopt) {
                $f_option .= ',' . $qopt;
            }
        } else {
            $f_option = '';
        }
        $url = '';

        if (isset($this->request->get['filter'])) {
            $url .= '&filter=' . $this->request->get['filter'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['limit'])) {
            $url .= '&limit=' . $this->request->get['limit'];
        }

        if (isset($this->request->get['brand'])) {
            $url .= '&brand=' . $this->request->get['brand'];
        }

        if (isset($this->request->get['option'])) {
            $url .= '&option=' . $this->request->get['option'];
        }

        $category_id = $this->request->post['category_id'];
        $filter_data = array(
            'filter_category_id' => $category_id,
            'filter_sub_category' => $this->config->get('config_subcategory_show'),
            'filter_filter' => $filter,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $limit,
            'limit' => $limit,
            'brand' => $f_brand,
            'option' => $f_option,
            'product_showcase' => 1,
        );




        $product_total = $this->model_catalog_product->getTotalProducts($filter_data);
        $results = $this->model_catalog_product->getProducts($filter_data);

        foreach ($results as $result) {

            if ($result['image']) {
                $image = $this->model_tool_image->resize($result['image'], $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height'), 'product_list');
            } else {
                $image = $this->model_tool_image->resize('placeholder.png', $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height'));
            }

            $images = $this->model_catalog_product->getProductImages($result['product_id']);
            $data['images'] = array();
            foreach ($images as $img) {
                $data['images'][] = array(
                    'popup' => $this->model_tool_image->resize($img['image'], $this->config->get($this->config->get('config_theme') . '_image_popup_width'), $this->config->get($this->config->get('config_theme') . '_image_popup_height'), 'product_list'),
                    'popup1' => $this->model_tool_image->resize($img['image'], $this->config->get($this->config->get('config_theme') . '_image_thumb_width'), $this->config->get($this->config->get('config_theme') . '_image_thumb_height'), 'product_list'),
                    'thumb' => $this->model_tool_image->resize($img['image'], $this->config->get($this->config->get('config_theme') . '_image_additional_width'), $this->config->get($this->config->get('config_theme') . '_image_additional_height'), 'product_list')
                );
            }

            if (isset($images[0]['image']) && !empty($images)) {
                $images = $images[0]['image'];
            } else {
                $images = $image;
            }

            if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                $soft_price = $this->currency->format($result['price'], $this->session->data['currency']);
            } else {
                $soft_price = false;
            }

            if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                $price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
            } else {
                $price = false;
            }

            if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                if ($result['currency_id'] == 1) {
                    $soft_currency_price = $this->currency->format($result['price'], 'TRY');
                } else {
                    $soft_currency_price = $this->currency->format($result['price'], 'USD');
                }
            } else {
                $soft_currency_price = false;
            }

            if ((float) $result['special']) {
                $special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                    if ($result['currency_id'] == 1) {
                        $soft_currency_special = $this->currency->format($result['special'], 'TRY');
                    } else {
                        $soft_currency_special = $this->currency->format($result['special'], 'USD');
                    }
                } else {
                    $soft_currency_special = false;
                }
            } else {
                $special = false;
                $soft_currency_special = false;
            }

            if ($this->config->get('config_tax')) {
                $tax = $this->currency->format((float) $result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
            } else {
                $tax = false;
            }

            if ($this->config->get('config_review_status')) {
                $rating = (int) $result['rating'];
            } else {
                $rating = false;
            }

            $options = array();
            foreach ($this->model_catalog_product->getProductOptions($result['product_id']) as $option) {
                $product_option_value_data = array();

                foreach ($option['product_option_value'] as $option_value) {
                    if ($option_value['subtract']) {
                        if ((($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) && (float) $option_value['price']) {
                            $o_price = $this->currency->format($this->tax->calculate($option_value['price'], $result['tax_class_id'], $this->config->get('config_tax') ? 'P' : false), $this->session->data['currency']);
                        } else {
                            $o_price = false;
                        }

                        $product_option_value_data[] = array(
                            'product_option_value_id' => $option_value['product_option_value_id'],
                            'option_value_id' => $option_value['option_value_id'],
                            'name' => $option_value['name'],
                            'quantity' => $option_value['quantity'],
                            'image' => $this->model_tool_image->resize($option_value['image'], 50, 50),
                            'price' => $o_price,
                            'price_prefix' => $option_value['price_prefix']
                        );
                    }
                }

                $options[] = array(
                    'product_option_id' => $option['product_option_id'],
                    'product_option_value' => $product_option_value_data,
                    'option_id' => $option['option_id'],
                    'name' => $option['name'],
                    'type' => $option['type'],
                    'value' => $option['value'],
                    'required' => $option['required']
                );
            }

            $p_related = $this->model_catalog_product->getProductRelated($result['product_id']);
            $product_related = array();
            foreach ($p_related as $related) {

                if ($related['image']) {
                    $r_image = $this->model_tool_image->resize($related['image'], $this->config->get($this->config->get('config_theme') . '_image_related_width'), $this->config->get($this->config->get('config_theme') . '_image_related_height'));
                    $r_image_p = $this->model_tool_image->resize($related['image'], $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height'));
                } else {
                    $r_image = $this->model_tool_image->resize('placeholder.png', $this->config->get($this->config->get('config_theme') . '_image_related_width'), $this->config->get($this->config->get('config_theme') . '_image_related_height'));
                    $r_image_p = $this->model_tool_image->resize('placeholder.png', $this->config->get($this->config->get('config_theme') . '_image_related_width'), $this->config->get($this->config->get('config_theme') . '_image_related_height'));
                }

                if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                    $r_price = $this->currency->format($this->tax->calculate($related['price'], $related['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                } else {
                    $r_price = false;
                }

                if ((float) $related['special']) {
                    $r_special = $this->currency->format($this->tax->calculate($related['special'], $related['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                } else {
                    $r_special = false;
                }

                $r_options = array();
                foreach ($this->model_catalog_product->getProductOptions($related['product_id']) as $option) {
                    $product_option_value_data = array();

                    foreach ($option['product_option_value'] as $option_value) {
                        if ($option_value['subtract']) {
                            if ((($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) && (float) $option_value['price']) {
                                $ro_price = $this->currency->format($this->tax->calculate($option_value['price'], $result['tax_class_id'], $this->config->get('config_tax') ? 'P' : false), $this->session->data['currency']);
                            } else {
                                $ro_price = false;
                            }

                            $product_option_value_data[] = array(
                                'product_option_value_id' => $option_value['product_option_value_id'],
                                'option_value_id' => $option_value['option_value_id'],
                                'name' => $option_value['name'],
                                'quantity' => $option_value['quantity'],
                                'image' => $this->model_tool_image->resize($option_value['image'], 50, 50),
                                'price' => $ro_price,
                                'price_prefix' => $option_value['price_prefix']
                            );
                        }
                    }

                    $r_options[] = array(
                        'product_option_id' => $option['product_option_id'],
                        'product_option_value' => $product_option_value_data,
                        'option_id' => $option['option_id'],
                        'name' => $option['name'],
                        'type' => $option['type'],
                        'value' => $option['value'],
                        'required' => $option['required']
                    );
                }

                $product_related[] = array(
                    'product_id' => $related['product_id'],
                    'name' => $related['name'],
                    'price' => $r_price,
                    'special' => $r_special,
                    'thumb' => $r_image,
                    'thumb_p' => $r_image_p,
                    'href' => $this->url->link('product/product', '&product_id=' . $related['product_id'], true),
                    'options' => $r_options
                );
            }


            $collection_color = $this->model_catalog_product->getCollectionColor($result['product_id'], $result['model'], $category_id);

            $data['products'][] = array(
                'product_id' => $result['product_id'],
                'model' => $result['model'],
                'product_type' => $result['product_type'],
                'thumb' => $image,
                'no_cache_image' => $config_url . $result['image'],
                'quantity' => $result['quantity'],
                'manufacturer' => $result['manufacturer'],
                'images' => $data['images'],
                'thumb_swap' => $this->model_tool_image->resize($images, $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height')),
                'name' => $result['name'],
                'description' => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get($this->config->get('config_theme') . '_product_description_length')) . '..',
                'price' => $price,
                'special' => $special,
                'soft_currency_price' => $soft_currency_price,
                'soft_currency_special' => $soft_currency_special,
                'percentsaving' => $result['special'] ? round((($result['price'] - $result['special']) / $result['price']) * 100, 0) : '',
                'tax' => $tax,
                'minimum' => $result['minimum'] > 0 ? $result['minimum'] : 1,
                'rating' => $result['rating'],
                'quick' => $this->url->link('product/quick_view', '&product_id=' . $result['product_id']),
                'href' => $this->url->link('product/product', 'product_id=' . $result['product_id'] . $url),
                'options' => $options,
                'product_related' => $product_related,
                'collection_color' => $collection_color,
            );
            $json['result'] = $this->load->view(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/product/show_products', $data);

            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode($json));
        }
    }

}
