<?php
class ControllerProductCategory extends Controller
{
    public function findsamecategory(){

        $this->load->model('catalog/category');

        $data = array();

        $data['url'] = '';

        if(isset($this->request->post['category_id'])){
            $category_id = $this->request->post['category_id'];
            $text = rtrim($this->request->post['asked']);
            $texts = explode(' ', $text);
            $text = $texts[count($texts) - 1];
            $category = $this->model_catalog_category->findSameCategory($category_id, $text);

            if(isset($category['category_id'])){
                $data['url'] = $category['href'];
            }


        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));
    }

    public function findsamecategories(){

        $this->load->model('catalog/category');
        $data = array();

        $data['sub_categories'] = array();

        if(isset($this->request->post['category_id'])){
            $category_id = $this->request->post['category_id'];
            $text = rtrim($this->request->post['asked']);
            $texts = explode(' ', $text);
            $text = $texts[count($texts) - 1];
            $categories = $this->model_catalog_category->findSameCategories($category_id, $text);

            $find_top_categories = array();
            foreach ($categories as $category){
                $find_sub_category = $this->model_catalog_category->getCategory($category['parent_id']); // alt kategori bilgisini buluyoruz.
               if(!empty($find_sub_category)){
                $find_top_category = $this->model_catalog_category->getCategory($find_sub_category['parent_id']); // alt kategori bilgisini buluyoruz.
                $find_top_categories[] = $find_top_category['category_id'];
                $data['sub_categories'][$find_top_category['category_id']][] = array(
                    'category_id' => $find_sub_category['category_id'],
                    'name' => str_replace('Telefon Kılıfı', '', $find_sub_category['name']),
                    'href' => $find_sub_category['href'],
                );
            }
            }

        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));
    }

    public function switchCategory(){

        $data = array();

        $this->load->model('catalog/category');
        $this->load->model('catalog/product');

        $data['breadcrumbs'] = array();


        if(isset($this->request->post['category_id'])){

            $data['all_categories'] = array();
            $data['sub_categories'] = array();
            $data['sub_categories2'] = array();

            $category_id = $this->request->post['category_id'];

            $categories = $this->model_catalog_category->getJsonCategory();
            
            foreach ($categories as $category){
                if($category['children']){
                    foreach ($category['children'] as $category_sub){
                        if($category_sub['children']){
                            foreach ($category_sub['children'] as $category_sub2){
                                $data['sub_categories2'][$category_sub['category_id']][] = array(
                                    'category_id' => $category_sub2['category_id'],
                                    'name' => str_replace('Telefon Kılıfı', '', $category_sub2['name']),
                                    'href' => $category_sub2['href'],
                                );
                            }
                        }
                        $data['sub_categories'][$category['category_id']][] = array(
                            'category_id' => $category_sub['category_id'],
                            'name' => str_replace('Telefon Kılıfı', '', $category_sub['name']),
                            'href' => $category_sub['href'],
                        );
                    }
                }
                $data['all_categories'][] = array(
                    'category_id' => $category['category_id'],
                    'name' => str_replace('Telefon Kılıfı', '', $category['name']),
                    'href' => $category['href'],
                );
            }

            $data['category_id'] = '';
            $data['sub_category_id'] = '';
            $data['sub_category_id2'] = '';


            $getCategoryPaths = $this->model_catalog_category->getCategoryPath($category_id);


            //Main Category
            if(isset($getCategoryPaths[0])){
                $data['category_id'] = $getCategoryPaths[0]['category_id'];
                $data['breadcrumbs'][] = array(
                    'text' => $getCategoryPaths[0]['name'],
                    'href' => $getCategoryPaths[0]['href'],
                );
            }

            //Sub Category
            if(isset($getCategoryPaths[1])){
                $data['sub_category_id'] = $getCategoryPaths[1]['category_id'];
                $data['breadcrumbs'][] = array(
                    'text' => $getCategoryPaths[1]['name'],
                    'href' => $getCategoryPaths[1]['href'],
                );
            }

            //Sub Category 2
            if(isset($getCategoryPaths[2])){
                $data['sub_category_id2'] = $getCategoryPaths[2]['category_id'];
                $data['breadcrumbs'][] = array(
                    'text' => $getCategoryPaths[2]['name'],
                    'href' => $getCategoryPaths[2]['href'],
                );

                //-------------------------------------------

                $data['all_categories'] = array();
                $data['sub_categories'] = array();

                $category_info = $this->model_catalog_category->getCategory($data['sub_category_id2']);

                $cat_name = str_replace(' Telefon Kılıfı', '', $category_info['name']);
                //$text = rtrim($category_info['name']);
                $texts = explode(' ', $cat_name);
                $text = $texts[count($texts) - 1];
                $categories = $this->model_catalog_category->findSameCategories(0, $text);


                $find_top_categories = array();
                foreach ($categories as $category){
                    $find_sub_category = $this->model_catalog_category->getCategory($category['parent_id']); // alt kategori bilgisini buluyoruz.
                    if(isset($find_sub_category['parent_id'])){
                        $find_top_category = $this->model_catalog_category->getCategory($find_sub_category['parent_id']); // alt kategori bilgisini buluyoruz.
                        if(isset($find_top_category['category_id'])){
                            $find_top_categories[] = $find_top_category['category_id'];
                            $data['sub_categories'][$find_top_category['category_id']][] = array(
                                'category_id' => $find_sub_category['category_id'],
                                'name' => str_replace('Telefon Kılıfı', '', $find_sub_category['name']),
                                'href' => $find_sub_category['href'],
                            );
                        }
                        
                    }
                   
                }

                $find_top_categories = array_unique($find_top_categories);
                foreach ($find_top_categories as $find_top_category_id){
                    $data['all_categories'][] = array(
                        'category_id' => $find_top_category_id,
                        'name' => str_replace('Telefon Kılıfı', '', $this->model_catalog_category->getCategory($find_top_category_id))['name'],
                        'href' => $this->model_catalog_category->getCategory($find_top_category_id)['href'],
                    );
                }


                //-------------------------------------------

            }

        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));

    }

	public function index()
	{

        if ($this->request->server['HTTPS']) {
            $config_url = $this->config->get('config_ssl') . 'image/';
        } else {
            $config_url = $this->config->get('config_url') . 'image/';
        }

		$this->load->language('product/category');
		$this->load->model('catalog/category');
		$this->load->model('catalog/product');
		$this->load->model('tool/image');

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['limit'])) {
            $limit = (int)$this->request->get['limit'];
        } else {
            $limit = 20;
        }

		$data['breadcrumbs'] = array();
		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => ''
		);

		if (isset($this->request->get['path'])) {
			$category_id = (int)$this->request->get['path'];
		} else {
			$category_id = 0;
		}


        $data['category_id'] = $category_id;
		$data['sub_category_id'] = '';
		$data['sub_category_id2'] = '';

        $data['all_categories'] = array();
        $data['sub_categories'] = array();
        $data['sub_categories2'] = array();

		$category_info = $this->model_catalog_category->getCategory($category_id);

		$route = 'product/category';
		$path = 'path=' . $this->request->get['path'];

		if ($category_info) {

            $data['category_list'] = array();
		    if($data['sub_category_id2'] == ''){
                $category_list = $this->model_catalog_category->getCategories($category_id);
                foreach ($category_list as $list_item){

                    if ($list_item['image']) {
                        $thumb = $this->model_tool_image->resize($list_item['image'], $this->config->get($this->config->get('config_theme') . '_image_category_width'), $this->config->get($this->config->get('config_theme') . '_image_category_height'));
                    } else {
                        $thumb = '';
                    }

                    if ($list_item['banner']) {
                        $banner = $this->model_tool_image->resize($list_item['banner'], 550, 393);
                    } else {
                        $banner = '';
                    }

                    $bs_products = $this->model_catalog_category->getBestSellerProductsByCategory($list_item['category_id']);

                    $best_seller_products = array();
                    foreach ($bs_products as $bs_product){
                        
                        
                         $color=$bs_product['attribute_groups'][1]['attribute'][0]['name'];
                        $collection=$bs_product['attribute_groups'][0]['attribute'][0]['name'];
                        
                        
                        if ($bs_product['image']) {
                            $bs_image = $this->model_tool_image->resize($bs_product['image'], $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height'), 'product_list');
                        } else {
                            $bs_image = $this->model_tool_image->resize('placeholder.png', $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height'));
                        }

                        if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                            $bs_price = $this->currency->format($this->tax->calculate($bs_product['price'], $bs_product['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                        } else {
                            $bs_price = false;
                        }

                        if ((float)$bs_product['special']) {
                            $bs_special = $this->currency->format($this->tax->calculate($bs_product['special'], $bs_product['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                        } else {
                            $bs_special = false;
                        }
                        
                        
                        $categorti_id_info = $this->model_catalog_product->getCategoryByProductId($bs_product['product_id']);
                       // $this->product->dump($categorti_id_info);
                        $breadcrumb1 = isset($categorti_id_info[0]['name']) ? $categorti_id_info[0]['name'] : '';
                        $breadcrumb2 = isset($categorti_id_info[1]['name']) ? $categorti_id_info[1]['name'] : '';
                        $breadcrumb3 = isset($categorti_id_info[2]['name']) ? $categorti_id_info[2]['name'] : '';
                        

                        $best_seller_products[] = array(
                            'product_id' => $bs_product['product_id'],
                            'model' => $bs_product['model'],
                            'product_type' => $bs_product['product_type'],
                            'thumb' => $bs_image,
                            'quantity' => $bs_product['quantity'],
                            'name' => $bs_product['name'],
                            'price' => $bs_price,
                            'special' => $bs_special,
                            'percentsaving' => $bs_product['special'] ? round((($bs_product['price'] - $bs_product['special']) / $bs_product['price']) * 100, 0) : '',
                            'href' => $bs_product['href'],
                            'currency' => $this->session->data['currency'],
                            'breadcrumb1'=>$breadcrumb1,
                            'breadcrumb2'=>$breadcrumb2,
                            'breadcrumb3'=>$breadcrumb3,
                            'color'=>$color,
                            'collection'=>$collection
                        );
                    }

                    $data['category_list'][] = array(
                        'thumb' => $thumb,
                        'banner' => $banner,
                        'name' => $list_item['name'],
                        'description' => html_entity_decode($list_item['description'], ENT_QUOTES, 'UTF-8'),
                        'href' => $list_item['href'],
                        'products' => $best_seller_products
                    );
                }
            }


			$this->document->setTitle($category_info['meta_title']);
			$this->document->setDescription($category_info['meta_description']);
			$this->document->setKeywords($category_info['meta_keyword']);

			$data['heading_title'] = $category_info['name'];

			$data['text_refine'] = $this->language->get('text_refine');
			$data['text_empty'] = $this->language->get('text_empty');
			$data['text_quantity'] = $this->language->get('text_quantity');
			$data['text_manufacturer'] = $this->language->get('text_manufacturer');
			$data['text_model'] = $this->language->get('text_model');
			$data['text_price'] = $this->language->get('text_price');
			$data['text_tax'] = $this->language->get('text_tax');
			$data['text_points'] = $this->language->get('text_points');
			$data['text_compare'] = '';
			$data['text_sort'] = $this->language->get('text_sort');
			$data['text_default'] = $this->language->get('text_default');
			$data['text_limit'] = $this->language->get('text_limit');
			$data['text_filter'] = $this->language->get('text_filter');

			$data['text_order_private'] = $this->language->get('text_order_private');
			$data['text_order_critical'] = $this->language->get('text_order_critical');
			$data['text_bestsaller'] = $this->language->get('text_bestsaller');
			$data['text_bestview'] = $this->language->get('text_bestview');
			$data['text_in_stock'] = $this->language->get('text_in_stock');
			$data['text_order_in_stock'] = $this->language->get('text_order_in_stock');

			$data['button_cart'] = $this->language->get('button_cart');
			$data['button_wishlist'] = $this->language->get('button_wishlist');
			$data['button_compare'] = $this->language->get('button_compare');
			$data['button_continue'] = $this->language->get('button_continue');
			$data['button_list'] = $this->language->get('button_list');
			$data['button_grid'] = $this->language->get('button_grid');
			$data['quick_view'] = $this->language->get('quick_view');

            $data['text_discount'] = $this->language->get('text_discount');
            $data['text_view'] = $this->language->get('text_view');
            $data['text_quick_view'] = $this->language->get('text_quick_view');
            $data['text_no_stock'] = $this->language->get('text_no_stock');
            $data['text_product_done'] = $this->language->get('text_product_done');


			if ($category_info['image']) {
				$data['thumb'] = $this->model_tool_image->resize($category_info['image'], $this->config->get($this->config->get('config_theme') . '_image_category_width'), $this->config->get($this->config->get('config_theme') . '_image_category_height'));
			} else {
				$data['thumb'] = '';
			}

            if ($category_info['banner']) {
                $data['banner'] = $this->model_tool_image->resize($category_info['banner'], $this->config->get($this->config->get('config_theme') . '_image_category_width'), $this->config->get($this->config->get('config_theme') . '_image_category_height'));
            } else {
                $data['banner'] = '';
            }

            $data['show_products'] = $category_info['show_products'];

			$this->document->setFBog($data['thumb']);

			$data['description'] = html_entity_decode($category_info['description'], ENT_QUOTES, 'UTF-8');
			$data['compare'] = '';

			$url = '';

			$data['categories'] = array();

			$data['products'] = array();

            $sort = 'p.sort_order';
            $order = 'ASC';

			$filter_data = array(
				'filter_category_id' => $category_id,
				'filter_sub_category' => $this->config->get('config_subcategory_show'),
				'filter_filter' => '',
				'sort' => $sort,
				'order' => $order,
				'start' => ($page - 1) * $limit,
				'limit' => $limit,
				'product_showcase' => 1,
			);

			if($category_info['show_products']){
                $product_total = 0;
                $results = $this->model_catalog_product->getProducts($filter_data);
            }else{
                $product_total = 0;
                $results = array();
            }

            $show_color_attribute = true;
            if (strpos($category_info['name'], 'DailyCase') !== false ||strpos($category_info['name'], 'AirPods') !== false || strpos($category_info['name'], 'Kablo Koruyucular') !== false || strpos($category_info['name'], 'Saat Kordonları') !== false ) {
                $show_color_attribute = false;
            }

			foreach ($results as $result) {
			    
			    
			    $categorti_id_info = $this->model_catalog_product->getCategoryByProductId($result['product_id']);
                    
                        $breadcrumb1 = $categorti_id_info[0]['name'];
                        $breadcrumb2 = $categorti_id_info[1]['name'];
                        $breadcrumb3 = $categorti_id_info[2]['name'];
                        
                       
                        $color=$result['attribute_groups'][1]['attribute'][0]['name'];
                        $collection=$result['attribute_groups'][0]['attribute'][0]['name'];

			    

                    if ($result['image']) {
                        $image = $this->model_tool_image->resize($result['image'], $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height'), 'product_list');
                    } else {
                        $image = $this->model_tool_image->resize('placeholder.png', $this->config->get($this->config->get('config_theme') . '_image_product_width'), $this->config->get($this->config->get('config_theme') . '_image_product_height'));
                    }

                    $images = $this->model_catalog_product->getProductImages($result['product_id']);
                    $data['images'] = array();
                    foreach ($images as $img) {
                        $data['images'][] = array(
                            'popup' => $this->model_tool_image->resize($img['image'], $this->config->get($this->config->get('config_theme') . '_image_popup_width'), $this->config->get($this->config->get('config_theme') . '_image_popup_height'),'product_list'),
                            'popup1' => $this->model_tool_image->resize($img['image'], $this->config->get($this->config->get('config_theme') . '_image_thumb_width'), $this->config->get($this->config->get('config_theme') . '_image_thumb_height'),'product_list'),
                            'thumb' => $this->model_tool_image->resize($img['image'], $this->config->get($this->config->get('config_theme') . '_image_additional_width'), $this->config->get($this->config->get('config_theme') . '_image_additional_height'),'product_list')
                        );
                    }

                    if (isset($images[0]['image']) && !empty($images)) {
                        $images = $images[0]['image'];
                    } else {
                        $images = $image;
                    }

                    if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                        $soft_price = $this->currency->format($result['price'], $this->session->data['currency']);
                    } else {
                        $soft_price = false;
                    }

                    if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                        $price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                    } else {
                        $price = false;
                    }

                    if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                        if ($result['currency_id'] == 1) {
                            $soft_currency_price = $this->currency->format($result['price'], 'TRY');
                        } else {
                            $soft_currency_price = $this->currency->format($result['price'], 'USD');
                        }
                    } else {
                        $soft_currency_price = false;
                    }

                    if ((float)$result['special']) {
                        $special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
                        if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
                            if ($result['currency_id'] == 1) {
                                $soft_currency_special = $this->currency->format($result['special'], 'TRY');
                            } else {
                                $soft_currency_special = $this->currency->format($result['special'], 'USD');
                            }
                        } else {
                            $soft_currency_special = false;
                        }
                    } else {
                        $special = false;
                        $soft_currency_special = false;
                    }

                    if ($this->config->get('config_tax')) {
                        $tax = $this->currency->format((float)$result['special'] ? $result['special'] : $result['price'], $this->session->data['currency']);
                    } else {
                        $tax = false;
                    }

                    if ($this->config->get('config_review_status')) {
                        $rating = (int)$result['rating'];
                    } else {
                        $rating = false;
                    }

                    $options = array();

                    //$p_related = $this->model_catalog_product->getProductRelated($result['product_id']);

                    $product_related = array();

                    $collection_color = $this->model_catalog_product->getCollectionColor($result['product_id'], $result['model'], $category_id,$show_color_attribute);
                   
                    $data['products'][] = array(
                        'product_id' => $result['product_id'],
                        'model' => $result['model'],
                        'product_type' => $result['product_type'],
                        'thumb' => $image,
                        'no_cache_image' => $config_url . $result['image'],
                        'quantity' => $result['quantity'],
                        'manufacturer' => $result['manufacturer'],
                        'images' => $data['images'],
                        'thumb_swap' => '',
                        'name' => $result['name'],
                        'description' => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get($this->config->get('config_theme') . '_product_description_length')) . '..',
                        'price' => $price,
                        'special' => $special,
                        'soft_currency_price' => $soft_currency_price,
                        'soft_currency_special' => $soft_currency_special,
                        'percentsaving' => '',
                        'tax' => $tax,
                        'minimum' => $result['minimum'] > 0 ? $result['minimum'] : 1,
                        'rating' => $result['rating'],
                        'quick' => '',
                        'href' => $result['href'],
                        'options' => $options,
                        'product_related' => $product_related,
                        'collection_color' => $collection_color,
                        'breadcrumb1'=>$breadcrumb1,
                        'breadcrumb2'=>$breadcrumb2,
                        'breadcrumb3'=>$breadcrumb3,
                        'currency'=>$this->session->data['currency'],
                        'color'=>$color,
                        'collection'=>$collection
                    );
                }




			$data['pagination'] = '';
			$data['results'] = 0;

			if ($page == 1) {
				$this->document->addLink(HTTPS_SERVER . $category_info['href'], 'canonical');
			} elseif ($page == 2) {
				$this->document->addLink(HTTPS_SERVER . $category_info['href'], 'prev');
			} else {
				$this->document->addLink(HTTPS_SERVER . $category_info['href'] . '&page=' . ($page - 1) , 'prev');
			}

			if ($limit && ceil($product_total / $limit) > $page) {
				$this->document->addLink($category_info['href'] . '&page=' . ($page + 1), 'next');
			}


			$data['order'] = $order;

			$data['continue'] = '';

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');

		    $data['footer'] = $this->cache->cache_get('category_footer' . $category_id, 'category_footer/');
			if (!$data['footer']) {
			    $data['footer'] = $this->load->controller('common/footer');
			    $this->cache->cache_set('category_footer' . $category_id, $data['footer'], 'category_footer/');
			}
			
			$data['header'] = $this->cache->cache_get('category_header' . $category_id, 'category_header/');
			if (!$data['header']) {
			    $data['header'] = $this->load->controller('common/header');
			    $this->cache->cache_set('category_header' . $category_id, $data['header'], 'category_header/');
			}
			
			if($_SERVER['REMOTE_ADDR']=='46.196.84.76'){
                //var_dump($data['category_list']); die;
            }



      $data['show_color_attribute'] = $show_color_attribute;

	        $data['CretioOneTag_status'] = $this->config->get('CretioOneTag_status');
            $data['CretioOneTag_id'] = $this->config->get('CretioOneTag_id');

            $tpl_name = 'category';
            if(strpos( $category_info['name'],'Halloween') !== false){
                $tpl_name = 'halloween';
            }

            if (file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/product/' . $tpl_name . '.tpl')) {
                $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/product/' . $tpl_name, $data));
            } else {
                $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/product/' . $tpl_name, $data));
            }
            
		} else {
			$url = '';

			if (isset($this->request->get['path'])) {
				$url .= '&path=' . $this->request->get['path'];
			}

			if (isset($this->request->get['filter'])) {
				$url .= '&filter=' . $this->request->get['filter'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}


			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_error'),
				'href' => $this->url->link('product/category', $url)
			);

			$this->document->setTitle($this->language->get('text_error'));

			$data['heading_title'] = $this->language->get('text_error');
			$data['text_error'] = $this->language->get('text_error');
			$data['button_continue'] = $this->language->get('button_continue');

			$data['continue'] = $this->url->link('common/home');

			$this->response->addHeader($this->request->server['SERVER_PROTOCOL'] . ' 404 Not Found');

			$data['column_left'] = $this->load->controller('common/column_left');
			$data['column_right'] = $this->load->controller('common/column_right');
			$data['content_top'] = $this->load->controller('common/content_top');
			$data['content_bottom'] = $this->load->controller('common/content_bottom');
			$data['footer'] = $this->load->controller('common/footer');
			$data['header'] = $this->load->controller('common/header');
			

			if (file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/error/not_found.tpl')) {
				$this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/error/not_found', $data));
			} else {
				$this->response->setOutput($this->load->view(DIR_TEMPLATE . 'error/not_found', $data));
			}
		}
	}

    public function getSubCategories()
    {

        $data['categories'] = array();

        if (isset($this->request->post['category_id'])) {
            $category_id = $this->request->post['category_id'];

            $this->load->model('catalog/category');
            $this->load->model('catalog/product');
            $this->load->model('tool/image');
            $categories = $this->model_catalog_category->getCategories($category_id);

            foreach ($categories as $result) {

                $filter_data = array(
                    'filter_category_id' => $result['category_id'],
                    'filter_sub_category' => true
                );

                $data['categories'][] = array(
                    'name' => $result['name'],
                    'href' => $this->url->link('product/category', 'path=' . $result['category_id']),
                    'category_id' => $result['category_id'],
                    //'image' => $result['image'] ? $this->model_tool_image->resize($result['image'], $this->config->get($this->config->get('config_theme') . '_image_cart_width'), $this->config->get($this->config->get('config_theme') . '_image_cart_height')) : false,
                );
            }
        }


        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($data));
    }

}
