<?php

class ControllerModuleReward extends Controller {
        /**
     * Üyelik ile yapılacak alışverişlerde sepet toplamına göre puan verilmesi
     * Event ile çalışır
     * Puan ayarları yönetim rotası: /ps-panel/index.php?route=extension/module/reward_setting
     * @author Can Yiğit KAV
     * 30.03.2022
     */
    public function index($route, $output) {
        $order_id = $output[0];
        $order_status_id = $output[1];

        # Sipariş 'Tamamlandı'(5) veya 'İptal Geri Alındı'(9) durumuna alınıyorsa
        if(in_array($order_status_id, ['5','9'])) {
            $reward_setting_status = $this->config->get('reward_setting_status');
            # Ödül Puanı eklentisi açıksa
            if($reward_setting_status) {
                $order_info = $this->getOrder($order_id);
                # Üyelikle yapılan alışverişse
                if(!empty($order_info['customer_id'])) {
                    $before_points = $this->getGainedBeforePoints($order_info['customer_id'], $order_id);
                    # Daha önce + puan eklenmemiş ise
                    if(count($before_points)==0) {
                        $reward_setting_status = $this->config->get('reward_setting_status');
                        $reward_setting_total_status = $this->config->get('reward_setting_total_status');
                        $reward_setting_percent = $this->config->get('reward_setting_percent');
                        $reward_setting_total_code = $reward_setting_total_status==1 ? 'total' : 'sub_total'; 
                        
                        $total_amount = $this->db->query("SELECT * FROM " .DB_PREFIX ."order_total 
                            WHERE order_id = ". $order_id ." 
                            AND code = '" . $reward_setting_total_code ."'"
                        )->row;
                        # DB'den tutara ulaşılabildi ise
                        if($total_amount['value']) {
                            $total_amount = str_replace(',', '.', $total_amount['value']);
                            $reward = ($total_amount * $reward_setting_percent) / 100;
                            $reward = number_format($reward, 2, '.', '');
                            $description = 'Sipariş No: #' . $order_id;
                            # Puan ekle
                            $this->db->query(" INSERT INTO " . DB_PREFIX . "customer_reward 
                                SET customer_id = '" . (int)$order_info['customer_id'] . "',  
                                order_id = '" . (int)$order_id . "',  
                                points = '" . (float)$reward . "', 
                                description = '" . $this->db->escape($description) . "', 
                                date_added = NOW()
                            ");	
                            $log = new Log('rewards.log');
                            $log->write('Sipariş No: #' . $order_id . ' ' . $reward . ' tutarında puan eklendi.');     
                        }
                    }
                }
            } # Sipariş 'İptal Edildi'(7) veya 'İade Edildi'(11) durumuna alınıyorsa
        } else if(in_array($order_status_id, ['7','11'])) { 
            $order_info = $this->getOrder($order_id);
            # Üyelikle yapılan alışverişse
            if(!empty($order_info['customer_id'])) {
                $before_points = $this->getGainedBeforePoints($order_info['customer_id'], $order_id);
                # daha önce + puan eklenmişse   
                if(count($before_points)>0) {
                    # puanı sil 
                    $this->db->query("DELETE FROM " . DB_PREFIX ."customer_reward 
                        WHERE customer_id =" . $order_info['customer_id']. " 
                        AND order_id =" . $order_id . " 
                        AND points > 0 
                    ");
                    $log = new Log('rewards.log');
                    $log->write('Sipariş No: #' . $order_id . ' puan silindi.');    
                }
            }
        } 
    }

    private function getOrder($order_id) {
        return $this->db->query("SELECT o.customer_id, o.order_id  
            FROM ps_order o
            WHERE order_id =" . $order_id
        )->row;
    }

    private function getGainedBeforePoints($customer_id, $order_id) {
        return $this->db->query("SELECT * FROM " . DB_PREFIX ."customer_reward WHERE customer_id =" . (int)$customer_id . " 
            AND order_id =" . $order_id . " 
            AND points > 0 "
        )->rows; 
    }

}

?>