<?php
class ControllerModuleDigitCartLoadProducts extends Controller {
	private $error = array();
	private $moduleName = 'digitcart_load_products';
	private $moduleFilePath = 'module/digitcart_load_products';
	public function index(){

	    //Koleksiyonumuza ait modellerimizin sonuna geldiniz. Diğer kolekstiyonlara göz atmak için <a href="/">Tıklayın</a> :)

       // $this->product->dump($this->request->get);

		if($this->config->get('digitcart_load_products_status') AND isset($this->request->get['path'])){
			$dc_pages = $this->config->get('digitcart_load_products_pages');
			$dc_current_route = (isset($this->request->get['route']) ? $this->request->get['route'] : '');

			if(is_array($dc_pages) && in_array($dc_current_route, (array)$dc_pages)){
				$this->load->model('catalog/category');
				$this->load->model('catalog/product');


				if (isset($this->request->get['filter'])) {
					$filter = $this->request->get['filter'];
				} else {
					$filter = '';
				}


				if (isset($this->request->get['sort'])) {
					$sort = $this->request->get['sort'];
				} else {
					$sort = 'p.sort_order';
				}
				if (isset($this->request->get['order'])) {
					$order = $this->request->get['order'];
				} else {
					$order = 'ASC';
				}
				if (isset($this->request->get['page'])) {
					$page = $this->request->get['page'];
				} else {
					$page = 1;
				}
				if (isset($this->request->get['limit'])) {
					$limit = (int)$this->request->get['limit'];
				} else {
					$limit = $this->config->get($this->config->get('config_theme') . '_product_limit');
				}
				if (isset($this->request->get['path'])) {
					$url = '';
					if (isset($this->request->get['sort'])) {
						$url .= '&sort=' . $this->request->get['sort'];
					}
					if (isset($this->request->get['order'])) {
						$url .= '&order=' . $this->request->get['order'];
					}
					if (isset($this->request->get['limit'])) {
						$url .= '&limit=' . $this->request->get['limit'];
					}
					$path = '';
					$parts = explode('_', (string)$this->request->get['path']);
					$category_id = (int)array_pop($parts);
				} else {
					$category_id = 0;
				}

                $this->load->model('catalog/category');

                $category_info = $this->model_catalog_category->getCategory($category_id);
                if(!$category_info){
                   // $this->request->redirect($this->url->link('common/home'));
                    exit();
                }

				if (isset($this->request->get['manufacturer_id'])) {
					$manufacturer_id = (int)$this->request->get['manufacturer_id'];
				} else {
					$manufacturer_id = 0;
				}
				if (isset($this->request->get['search'])) {
					$search = $this->request->get['search'];
				} else {
					$search = '';
				}
				if (isset($this->request->get['tag'])) {
					$tag = $this->request->get['tag'];
				} elseif (isset($this->request->get['search'])) {
					$tag = $this->request->get['search'];
				} else {
					$tag = '';
				}
				if (isset($this->request->get['description'])) {
					$description = $this->request->get['description'];
				} else {
					$description = '';
				}
				if($dc_current_route == 'product/search'){
					if (isset($this->request->get['category_id'])) {
						$category_id = $this->request->get['category_id'];
					} else {
						$category_id = 0;
					}
				}
				if (isset($this->request->get['sub_category'])) {
					$sub_category = $this->request->get['sub_category'];
				} else {
					$sub_category = '';
				}
				
				if (isset($this->request->get['sort'])) {
        			$sort = $this->request->get['sort'];
        		} else {
        			$sort = 'p.sort_order';
        		}
        		
        		if (isset($this->request->get['order'])) {
        			$order = $this->request->get['order'];
        		} else {
        			$order = 'ASC';
        		}
        		
        		if (isset($this->request->get['brand'])) {
        			$f_brand = '';
        			$qbrand = explode(',', $this->request->get['brand']);
        			$qbrand = array_unique($qbrand);
        
        			foreach ($qbrand as $qbk => $brn) {
        				$f_brand .= ',' . $brn;
        			}
        		} else {
        			$f_brand = '';
        		}
        		
        		if (isset($this->request->get['option'])) {
        			$f_option = '';
        			$qoption = explode(',', $this->request->get['option']);
        			$qoption = array_unique($qoption);
        			foreach ($qoption as $qopt) {
        				$f_option .= ',' . $qopt;
        			}
        		} else {
        			$f_option = '';
        		}
        		
				$filter_data = array(
					'filter_name'         => $search,
					'filter_tag'          => $tag,
					'filter_description'  => $description,
					'filter_category_id'  => $category_id,
					'filter_sub_category' => $sub_category,
					'filter_manufacturer_id' => $manufacturer_id,
					'filter_filter'      => $filter
				);
				
				if($dc_current_route == 'product/category'){
				    $filter_data['filter_sub_category'] = $this->config->get('config_subcategory_show');
				    $filter_data['product_showcase'] = 1;
				    $filter_data['sort'] = $sort;
				    $filter_data['order'] = $order;
				    $filter_data['brand'] = $f_brand;
				    $filter_data['option'] = $f_option;
				}


				$product_total = $this->model_catalog_product->getTotalProducts($filter_data);

				if($dc_current_route == 'product/special'){
					$product_total = $this->model_catalog_product->getTotalProductSpecials();
				}

				$dc_css_classes = '';
				if($this->config->get('digitcart_load_products_css_class')){
					$dc_css_classes .= $this->config->get('digitcart_load_products_css_class');
				}
				if($this->config->get('digitcart_load_products_effect_status')){
					$this->document->addStyle('catalog/view/theme/default/stylesheet/animate.min.css');
					$dc_css_classes .= ' animated';
					if($this->config->get('digitcart_load_products_effects')){
						if(count($this->config->get('digitcart_load_products_effects')) > 1){
							$dc_css_classes .= ' ' . $this->config->get('digitcart_load_products_effects')[rand(0, count($this->config->get('digitcart_load_products_effects')) - 1)];
						} else {
							$dc_css_classes .= ' ' . $this->config->get('digitcart_load_products_effects')[0];
						}
					}
				}
				$dc_data['dc_delay'] = $this->config->get('digitcart_load_products_animation_delay') ? $this->config->get('digitcart_load_products_animation_delay') : '0';
				$dc_data['dc_pagination_status'] = $this->config->get('digitcart_load_products_pagination_status') ? '1' : '0';
				$dc_data['dc_wrap_status'] = $this->config->get('digitcart_load_products_wrap_status') ? '1' : '0';
				$dc_data['dc_button_load'] = $this->config->get('digitcart_load_products_button_load') ? '1' : '0';
				$dc_data['dc_disable_mobile'] = $this->config->get('digitcart_load_products_disable_mobile') ? '1' : '0';
				$dc_item_selector = $this->config->get('digitcart_load_products_selector') ? $this->config->get('digitcart_load_products_selector') : "#content .product-layout";
				$dc_data['dc_item_selector'] = html_entity_decode($dc_item_selector, ENT_QUOTES, 'utf-8');
				$dc_pagination_row = $this->config->get('digitcart_load_products_pagination_row') ? $this->config->get('digitcart_load_products_pagination_row') : "('.pagination').parent().parent()";
				$dc_data['dc_pagination_row'] = html_entity_decode($dc_pagination_row, ENT_QUOTES, 'utf-8');
				$lang_id = $this->config->get('config_language_id');
				if($this->config->get('digitcart_load_products_custom_html_status')){
					$dc_loading_icon = $this->config->get('digitcart_load_products_loading_icon');
					if(!empty($dc_loading_icon[$lang_id])){
						$dc_loading_icon = html_entity_decode($dc_loading_icon[$lang_id], ENT_QUOTES, 'utf-8');
					} else {
						$dc_loading_icon = '';
					}
				} else {
					$dc_loading_icon = '<div style="text-align:center;font-size:40px;margin:20px 0;clear:both"><i class="fa fa-spin fa-spinner" style="font-size:40px;"></i></div>';
				}
				$dc_finished_text = $this->config->get('digitcart_load_products_finished_text');
				if(!empty($dc_finished_text[$lang_id])){
				    $cat_info = $this->model_catalog_category->getCategory($category_id);
					$dc_finished_text =  str_replace('Telefon Kılıfı', '', $cat_info['name']) . html_entity_decode($dc_finished_text[$lang_id], ENT_QUOTES, 'utf-8');
				} else {
					$dc_finished_text = '<div style="text-align:center">No more products!</div>';
				}
				$dc_load_more_text = $this->config->get('digitcart_load_products_load_more_text');
				if(!empty($dc_load_more_text[$lang_id])){
					$dc_load_more_text = html_entity_decode($dc_load_more_text[$lang_id], ENT_QUOTES, 'utf-8');
				} else {
					$dc_load_more_text = '<span class="btn btn-default"><i class="fa fa-bolt"></i> Load More</span>';
				}



				$dc_data['dc_load_more_text'] = $dc_load_more_text;
				$dc_data['dc_finished_text'] = $dc_finished_text;
				$dc_data['dc_loading_icon'] = $dc_loading_icon;
				$dc_data['dc_css_classes'] = $dc_css_classes;
				$dc_data['page'] = $page;
				$dc_data['filter'] = $filter;
				$dc_data['limit'] = $limit;
				$dc_data['product_total'] = $product_total;
				$threshold = $this->config->get('digitcart_load_products_threshold');
				$dc_data['threshold'] = (int)$threshold;
				$wrap_count = $this->config->get('digitcart_load_products_wrap_count');
				$dc_data['wrap_count'] = (int)$wrap_count;
				$custom_js = $this->config->get('digitcart_load_products_custom_js');
				$dc_data['custom_js'] = html_entity_decode($custom_js, ENT_QUOTES, 'utf-8');
				$dc_data['wrapper_class'] = $this->config->get('digitcart_load_products_wrapper_class');


				if (file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/' . $this->moduleFilePath.'.tpl')) {
					return $this->load->view(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory'). '/template/' . $this->moduleFilePath, $dc_data);
				} else {
					return $this->load->view('default/template/' . $this->moduleFilePath, $dc_data);
				}
			}
		}
	}
}