<?php
class ControllerInformationSitemap extends Controller {
	public function index() {

		$this->load->language('information/sitemap');
		$this->document->setTitle($this->language->get('heading_title'));
    
        //breadcrumbs data
        $this->load->language('common/header');

        if ($this->request->server['HTTPS']) {
        $server = $this->config->get('config_ssl');
        } else {
        $server = $this->config->get('config_url');
        }
        $data['base'] = $server;
        $data['text_home'] = $this->language->get('text_home');
        
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('information/sitemap')
		);
        
         $breadcrumbs1 = array();
            $count=1;
            foreach($data['breadcrumbs'] as $bread){
                $breadcrumbs1 = array([
                 "@type"=> "ListItem",
                 "position"=> $count,
                 "name"=> $bread['text'],
                 "item"=> $bread['href']]);
                $count++;
            }
        $data['breadcrumbs1']=  json_encode($breadcrumbs1);

		$data['heading_title'] = $this->language->get('heading_title');

		if(isset($this->request->get['part'])){
		    $part = $this->request->get['part'];
        }else{
            $part = false;
        }


		$this->load->model('catalog/category');
		$this->load->model('catalog/product');

		$data['categories'] = array();
        $data['products'] = array();

		if(!$part){
            $categories_1 = $this->model_catalog_category->getCategories(0);
            foreach ($categories_1 as $category_1) {
                $level_2_data = array();
                $categories_2 = $this->model_catalog_category->getCategories($category_1['category_id']);
                foreach ($categories_2 as $category_2) {
                    $level_3_data = array();
                    $categories_3 = $this->model_catalog_category->getCategories($category_2['category_id']);
                    foreach ($categories_3 as $category_3) {
                        $level_3_data[] = array(
                            'name' => $category_3['name'],
                            'href' => $this->url->link('product/category', 'path=' . $category_3['category_id'])
                        );
                    }
                    $level_2_data[] = array(
                        'name'     => $category_2['name'],
                        'children' => $level_3_data,
                        'href'     => $this->url->link('product/category', 'path=' . $category_2['category_id'])
                    );
                }
                $data['categories'][] = array(
                    'name'     => $category_1['name'],
                    'children' => $level_2_data,
                    'href'     => $this->url->link('product/category', 'path=' . $category_1['category_id'])
                );
            }
        }
		else{

		    if($part == 1){
                $limit = '0, '. $part .'0000';
            }else{
                $limit = ($part - 1) .'0000, '. $part .'0000';
            }


            $products = $this->db->query("SELECT p.product_id, pd.name, p.status FROM ps_product p LEFT JOIN ps_product_description pd ON (p.product_id = pd.product_id) WHERE p.status = '1' LIMIT ". $limit ." ")->rows;
            foreach ($products as $product){
                $data['products'][] = array(
                    'name' => $product['name'],
                    'href' => $this->url->link('product/product', 'product_id=' . $product['product_id']),
                );
            }
        }





		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');


		if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/information/sitemap.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/information/sitemap', $data));
		}else{ 
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/information/sitemap', $data));
		}

		
	}
}