<?php

use PHPMailer\PHPMailer\PHPMailer;

use PHPMailer\PHPMailer\Exception;

use PHPMailer\PHPMailer\SMTP;



class ControllerInformationContact extends Controller {

	private $error = array();



	public function index() {

		$this->load->language('information/contact');



		$this->document->setTitle($this->language->get('heading_title'));



		$data['CretioOneTag_status'] = '';



		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

			$mail = new SendgridMail($this->config->get('sendgrid_api_key'));



			$mail->protocol = $this->config->get('config_mail_protocol');

			$mail->parameter = $this->config->get('config_mail_parameter');

			$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');

			$mail->smtp_username = $this->config->get('config_mail_smtp_username');

			$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');

			$mail->smtp_port = $this->config->get('config_mail_smtp_port');

			$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');





			$mail->setTo('mh@deercase.com');

			$mail->setFrom($this->request->post['email']);

			$mail->setSender(html_entity_decode($this->request->post['name'], ENT_QUOTES, 'UTF-8'));

			$mail->setSubject(html_entity_decode(sprintf($this->language->get('email_subject'), $this->request->post['name']), ENT_QUOTES, 'UTF-8'));

			$mail->setText($this->request->post['enquiry']);

			$mail->send();





			$log = new Log("ConctactForm.txt");

			$log->write(html_entity_decode(sprintf($this->language->get('email_subject'), $this->request->post['name']), ENT_QUOTES, 'UTF-8'));

			$log->write($this->request->post['enquiry']);

			$log->write($this->request->post['email']);

			$log->write("-----------------------------------------------------------------");



			$this->response->redirect($this->url->link('information/contact/success'));

		}



		$data['breadcrumbs'] = array();



		$data['breadcrumbs'][] = array(

			'text' => $this->language->get('text_home'),

			'href' => $this->url->link('common/home', '', true)

		);



		$data['breadcrumbs'][] = array(

			'text' => $this->language->get('heading_title'),

			'href' => $this->url->link('information/contact', '', true)

		);
        $breadcrumbs1 = array();
            $count=1;
            foreach($data['breadcrumbs'] as $bread){
                $breadcrumbs1 = array([
                 "@type"=> "ListItem",
                 "position"=> $count,
                 "name"=> $bread['text'],
                 "item"=> $bread['href']]);
                $count++;
            }
        $data['breadcrumbs1']=  json_encode($breadcrumbs1);


		$data['heading_title'] = $this->language->get('heading_title');



		$data['text_location'] = $this->language->get('text_location');

		$data['text_store'] = $this->language->get('text_store');

		$data['text_contact'] = $this->language->get('text_contact');

		$data['text_address'] = $this->language->get('text_address');

		$data['text_telephone'] = $this->language->get('text_telephone');

		$data['text_fax'] = $this->language->get('text_fax');

		$data['text_open'] = $this->language->get('text_open');

		$data['text_comment'] = $this->language->get('text_comment');



		$data['entry_name'] = $this->language->get('entry_name');

		$data['entry_email'] = $this->language->get('entry_email');

		$data['entry_enquiry'] = $this->language->get('entry_enquiry');

		$data['entry_telephone'] = $this->language->get('entry_telephone');



		$data['button_map'] = $this->language->get('button_map');



		if (isset($this->error['name'])) {

			$data['error_name'] = $this->error['name'];

		} else {

			$data['error_name'] = '';

		}



		if (isset($this->error['email'])) {

			$data['error_email'] = $this->error['email'];

		} else {

			$data['error_email'] = '';

		}



        if (isset($this->error['telephone'])) {

            $data['error_telephone'] = $this->error['telephone'];

        } else {

            $data['error_telephone'] = '';

        }



		if (isset($this->error['enquiry'])) {

			$data['error_enquiry'] = $this->error['enquiry'];

		} else {

			$data['error_enquiry'] = '';

		}



		$data['button_submit'] = $this->language->get('button_submit');



		$data['action'] = $this->url->link('information/contact', '', true);



		$this->load->model('tool/image');



		if ($this->config->get('config_image')) {

			$data['image'] = $this->model_tool_image->resize($this->config->get('config_image'), $this->config->get($this->config->get('config_theme') . '_image_location_width'), $this->config->get($this->config->get('config_theme') . '_image_location_height'));

		} else {

			$data['image'] = false;

		}



		$data['store'] = $this->config->get('config_name');

		$data['address'] = nl2br($this->config->get('config_address'));

		$data['geocode'] = $this->config->get('config_geocode');

		$data['geocode_hl'] = $this->config->get('config_language');

		$data['telephone'] = $this->config->get('config_telephone');

		$data['fax'] = $this->config->get('config_fax');

		$data['open'] = nl2br($this->config->get('config_open'));

		$data['comment'] = $this->config->get('config_comment');



		$data['config_name'] = $this->config->get('config_name');

		$data['config_owner'] = $this->config->get('config_owner');

		$data['config_gsm'] = $this->config->get('config_gsm');

		$data['config_email'] = $this->config->get('config_email');

		$data['config_comment'] = $this->config->get('config_comment');



		$data['locations'] = array();



		$this->load->model('localisation/location');



		foreach((array)$this->config->get('config_location') as $location_id) {

			$location_info = $this->model_localisation_location->getLocation($location_id);



			if ($location_info) {

				if ($location_info['image']) {

					$image = $this->model_tool_image->resize($location_info['image'], $this->config->get($this->config->get('config_theme') . '_image_location_width'), $this->config->get($this->config->get('config_theme') . '_image_location_height'));

				} else {

					$image = false;

				}



				$data['locations'][] = array(

					'location_id' => $location_info['location_id'],

					'name'        => $location_info['name'],

					'address'     => nl2br($location_info['address']),

					'geocode'     => $location_info['geocode'],

					'telephone'   => $location_info['telephone'],

					'fax'         => $location_info['fax'],

					'image'       => $image,

					'open'        => nl2br($location_info['open']),

					'comment'     => $location_info['comment']

				);

			}

		}



		if (isset($this->request->post['name'])) {

			$data['name'] = $this->request->post['name'];

		} else {

			$data['name'] = $this->customer->getFirstName();

		}



		if (isset($this->request->post['email'])) {

			$data['email'] = $this->request->post['email'];

		} else {

			$data['email'] = $this->customer->getEmail();

		}



		if (isset($this->request->post['telephone'])) {

			$data['telephone'] = $this->request->post['telephone'];

		} else {

			$data['telephone'] = $this->customer->getTelephone();

		}



		if (isset($this->request->post['enquiry'])) {

			$data['enquiry'] = $this->request->post['enquiry'];

		} else {

			$data['enquiry'] = '';

		}



		// Captcha

		if ($this->config->get($this->config->get('config_captcha') . '_status') && in_array('contact', (array)$this->config->get('config_captcha_page'))) {

			$data['captcha'] = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha'), $this->error);

		} else {

			$data['captcha'] = '';

		}



		$data['column_left'] = $this->load->controller('common/column_left');

		$data['column_right'] = $this->load->controller('common/column_right');

		$data['content_top'] = $this->load->controller('common/content_top');

		$data['content_bottom'] = $this->load->controller('common/content_bottom');

		$data['footer'] = $this->load->controller('common/footer');

		$data['header'] = $this->load->controller('common/header');



		if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/information/contact.tpl')){

		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/information/contact', $data));

		}else{ 

		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/information/contact', $data));

		}



		

	}



	protected function validate() { 



		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 32)) {

			$this->error['name'] = $this->language->get('error_name');

		}



		if (!filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {

			$this->error['email'] = $this->language->get('error_email');

		}



        if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {

            $this->error['telephone'] = $this->language->get('error_telephone');

        }



		if ((utf8_strlen($this->request->post['enquiry']) < 10) || (utf8_strlen($this->request->post['enquiry']) > 3000)) {

			$this->error['enquiry'] = $this->language->get('error_enquiry');

		}



		// Captcha

		if ($this->config->get($this->config->get('config_captcha') . '_status') && in_array('contact', (array)$this->config->get('config_captcha_page'))) {

			$captcha = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha') . '/validate');



			if ($captcha) {

				$this->error['captcha'] = $captcha;

			}

		}



		return !$this->error;

	}



	public function success() {

		$this->load->language('information/contact');



		$this->document->setTitle($this->language->get('heading_title'));



        $data['CretioOneTag_status'] = '';


        $this->load->language('common/header');

        if ($this->request->server['HTTPS']) {
        $server = $this->config->get('config_ssl');
        } else {
        $server = $this->config->get('config_url');
        }
        $data['base'] = $server;
        $data['text_home'] = $this->language->get('text_home');
        
		$data['breadcrumbs'] = array();



		$data['breadcrumbs'][] = array(

			'text' => $this->language->get('text_home'),

			'href' => $this->url->link('common/home')

		);



		$data['breadcrumbs'][] = array(

			'text' => $this->language->get('heading_title'),

			'href' => $this->url->link('information/contact')

		);



		$data['heading_title'] = $this->language->get('heading_title');



		$data['text_message'] = $this->language->get('text_success');



		$data['button_continue'] = $this->language->get('button_continue');



		$data['continue'] = $this->url->link('common/home');



		$data['column_left'] = $this->load->controller('common/column_left');

		$data['column_right'] = $this->load->controller('common/column_right');

		$data['content_top'] = $this->load->controller('common/content_top');

		$data['content_bottom'] = $this->load->controller('common/content_bottom');

		$data['footer'] = $this->load->controller('common/footer');

		$data['header'] = $this->load->controller('common/header');



		if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/common/success.tpl')){

		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/common/success', $data));

		}else{ 

		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/common/success', $data));

		}



		

	}



    public function send()

    {



        //require 'path/to/PHPMailer/src/Exception.php';

        //require 'path/to/PHPMailer/src/PHPMailer.php';

        //require 'path/to/PHPMailer/src/SMTP.php';









        $mail = new PHPMailer(true);



        try {

            //Server settings

            $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      // Enable verbose debug output

            $mail->isSMTP();                                            // Send using SMTP

            $mail->Host       = 'smtp.yandex.com';

            //$mail->SMTPSecure = 'tls';// Set the SMTP server to send through

            $mail->SMTPAuth   = true;                                   // Enable SMTP authentication

            $mail->Username   = 'melihcan.zorlu@piyersoft.com';                     // SMTP username

            $mail->Password   = '+Fb1907caN';                               // SMTP password

            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;         // Enable TLS encryption; `PHPMailer::ENCRYPTION_SMTPS` also accepted

            $mail->Port       = 587;                                    // TCP port to connect to



            //Recipients

            $mail->setFrom('bilal.cakir@piyersoft.com', 'Mailer');

            $mail->addAddress('bilal603@gmail.com', 'Joe User');     // Add a recipient

            $mail->addAddress('mh@deercase.com', 'Joe User');     // Add a recipient

            $mail->addAddress('harun@deercase.com');               // Name is optional

            $mail->addReplyTo('noreply@example.com', 'Information');





            // Content

            $mail->isHTML(true);                                  // Set email format to HTML

            $mail->Subject = 'Here is the subject';

            $mail->Body    = 'This is the HTML message body <b>in bold!</b>';

            $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';



            $mail->send();





            echo 'Message has been sent';

        } catch (Exception $e) {

            //echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";

        }









        /*



        $mail = new PHPMailer;



        //Tell PHPMailer to use SMTP

        $mail->isSMTP();

        //Enable SMTP debugging

        // 0 = off (for production use)

        // 1 = client messages

        // 2 = client and server messages

        $mail->SMTPDebug = 2;

        //Ask for HTML-friendly debug output

        $mail->Debugoutput = 'html';

        //Set the hostname of the mail server

        $mail->Host = "mail.deercase.com";

        //Set the SMTP port number - likely to be 25, 465 or 587

        $mail->Port = 587;

        //Whether to use SMTP authentication

        $mail->SMTPAuth = true;

        //Username to use for SMTP authentication

        $mail->Username = "noreply@deercase.com";

        //Password to use for SMTP authentication

        $mail->Password = "1HJTfS,Yqrst";

        //Set who the message is to be sent from

        $mail->setFrom('bilal.cakir@deercase.com', 'First Last');

        //Set an alternative reply-to address

        //$mail->addReplyTo('replyto@example.com', 'First Last');

        //Set who the message is to be sent to

        $mail->addAddress('info@deercase.com', 'Deercase Info Mail');

        //Set the subject line

        $mail->Subject = 'PHPMailer SMTP test';

        //Read an HTML message body from an external file, convert referenced images to embedded,

        //convert HTML into a basic plain-text alternative body

        $mail->msgHTML(file_get_contents('https://www.deercase.com/index.php?route=account/guestorder'), dirname(__FILE__));

        //Replace the plain text body with one created manually

        $mail->AltBody = 'This is a plain-text message body';

        //Attach an image file

        //$mail->addAttachment('images/phpmailer_mini.png');



        //send the message, check for errors

        if (!$mail->send()) {

            echo "Mailer Error: " . $mail->ErrorInfo;

        } else {

            echo "Message sent!";

        } */





    }

}

