<?php
class ControllerFeedGoogleSitemapProduct extends Controller{

    public function index(){

        if ($this->config->get('google_sitemap_status')) {

            $this->load->model('catalog/product');
            $this->load->model('tool/image');

            $output  = '<?xml version="1.0" encoding="UTF-8"?>';
            $output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';

            if(isset($this->request->get['start'])){
                $start = (int)$this->request->get['start'];
            }else{
                $start = 0;
            }

            if(isset($this->request->get['limit'])){
                $limit = (int)$this->request->get['limit'];
            }else{
                $limit = 10;
            }

            $limit = 2500;

            $cache_name = 'product_' . $start . '-' . $limit;

            $limit = $start . ',' . $limit;

            $products = 0;
            if($this->cache->cache_get('product_' . $cache_name, 'google_site_map_product_cache/'))
                $products = $this->cache->cache_get('product_' . $cache_name, 'google_site_map_product_cache/');


            if(!$products){
                $products = $this->db->query("SELECT pd.name, p.image, p.product_id, pd.href, p.date_modified FROM ps_product p
                LEFT JOIN ps_product_description pd ON (p.product_id = pd.product_id)
                WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND p.status = '1' AND p.date_available <= NOW() LIMIT ". $limit ." ")->rows;
                $this->cache->cache_set('product_' . $cache_name, $products, 'google_site_map_product_cache/');
            }

            foreach ($products as $p_info) {

                if ($p_info['image']) {
                    $output .= '<url>';
                    $output .= '<loc>' . HTTPS_SERVER . $p_info['href'] . '</loc>';
                    $output .= '<changefreq>weekly</changefreq>';
                    $output .= '<lastmod>' . date('Y-m-d\TH:i:sP', strtotime($p_info['date_modified'])) . '</lastmod>';
                    $output .= '<priority>1.0</priority>';
                    $output .= '<image:image>';
                    $output .= '<image:loc>' . $this->model_tool_image->resize($p_info['image'], $this->config->get($this->config->get('config_theme') . '_image_popup_width'), $this->config->get($this->config->get('config_theme') . '_image_popup_height')) . '</image:loc>';
                    $output .= '<image:caption><![CDATA[' . $p_info['name'] . ']]></image:caption>';
                    $output .= '<image:title><![CDATA[' . $p_info['name'] . ']]></image:title>';
                    $output .= '</image:image>';
                    $output .= '</url>'; 
                }
            }



            $output .= '</urlset>';

            $this->response->addHeader('Content-Type: application/xml');
            $this->response->setOutput($output);

        }

    }

    public function test()
    {

        $output  = '<?xml version="1.0" encoding="UTF-8"?>';
        $output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';

        if(isset($this->request->get['start'])){
            $start = (int)$this->request->get['start'];
        }else{
            $start = 0;
        }

        if(isset($this->request->get['limit'])){
            $limit = (int)$this->request->get['limit'];
        }else{
            $limit = 10;
        }

        $mongo = new MongoDB();

        $this->load->model('tool/image');
        $products = $mongo->query(array(), array('skip' => $start, 'limit' => $limit), 'deercase.products');

        foreach ($products as $product){
            if ($product->image) {
                $output .= '<url>';
                $output .= '<loc>' . HTTPS_SERVER . $product->href . '</loc>';
                $output .= '<changefreq>weekly</changefreq>';
                $output .= '<lastmod>' . date('Y-m-d\TH:i:sP', strtotime($product->date_modified)) . '</lastmod>';
                $output .= '<priority>'. ($product->product_showcase ? '0.9' : '0.7') .'</priority>';
                $output .= '<image:image>';
                $output .= '<image:loc>' . $this->model_tool_image->resize($product->image, $this->config->get($this->config->get('config_theme') . '_image_popup_width'), $this->config->get($this->config->get('config_theme') . '_image_popup_height')) . '</image:loc>';
                $output .= '<image:caption><![CDATA[' . $product->name . ']]></image:caption>';
                $output .= '<image:title><![CDATA[' . $product->name . ']]></image:title>';
                $output .= '</image:image>';
                $output .= '</url>';
                //$this->setCache('product_' . $product->product_id, $output);
            }


        }

        $output .= '</urlset>';

        $this->response->addHeader('Content-Type: application/xml');
        $this->response->setOutput($output);

    }


}