<?php
class ControllerFeedGoogleSitemapCategory extends Controller{

    public function index(){

        if ($this->config->get('google_sitemap_status')) {

            $this->load->model('catalog/category');

            $output  = '<?xml version="1.0" encoding="UTF-8"?>';
            $output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';

            $categories_1 = $this->model_catalog_category->getCategories(0);

            foreach ($categories_1 as $category_1) {
                $categories_2 = $this->model_catalog_category->getCategories($category_1['category_id']);
                foreach ($categories_2 as $category_2) {
                    $categories_3 = $this->model_catalog_category->getCategories($category_2['category_id']);
                    foreach ($categories_3 as $category_3) {
                        $output .= '<url>';
                        $output .= '<loc>' . $this->url->link('product/category', 'path=' . $category_3['category_id']) . '</loc>';
                        $output .= '<changefreq>weekly</changefreq>';
                        $output .= '<priority>1.0</priority>';
                        $output .= '</url>';
                    }
                    $output .= '<url>';
                    $output .= '<loc>' . $this->url->link('product/category', 'path=' . $category_2['category_id']) . '</loc>';
                    $output .= '<changefreq>weekly</changefreq>';
                    $output .= '<priority>1.0</priority>';
                    $output .= '</url>';
                }

                $output .= '<url>';
                $output .= '<loc>' . $this->url->link('product/category', 'path=' . $category_1['category_id']) . '</loc>';
                $output .= '<changefreq>weekly</changefreq>';
                $output .= '<priority>1.0</priority>';
                $output .= '</url>';
            }

            $output .= '</urlset>';

            $this->response->addHeader('Content-Type: application/xml');
            $this->response->setOutput($output);

        }

    }

}