<?php
class ControllerExtensionModuleSlideshow extends Controller {
	public function index($setting) {

		static $module = 0;
        $data['module'] = $module++;


		$this->load->model('design/banner');
		$this->load->model('tool/image');

		$this->document->addStyle('//scripts.piyersoft.com/javascript/owl-carousel/owl.carousel.css');
		$this->document->addStyle('//scripts.piyersoft.com/javascript/owl-carousel/owl.transitions.css');
		$this->document->addScript('//scripts.piyersoft.com/javascript/owl-carousel/owl.carousel.min.js');

		$data['banners'] = array();

		$results = $this->model_design_banner->getBanner($setting['banner_id']);


        if($this->config->get('config_cdn_link')){
            $config_url = $this->config->get('config_cdn_link') . 'image/';
        }else{
            if ($this->request->server['HTTPS']) {
                $config_url = $this->config->get('config_ssl') . 'image/';
            } else {
                $config_url = $this->config->get('config_url') . 'image/';
            }
        }

        //echo $results[0]['name'];
        //dd($results);

        $data['bannerType'] = (isset($results[0]['type'])) ? $results[0]['type']:1;
        $data['bannerTitle'] = (isset($results[0]['name'])) ? $results[0]['name']:'';
        $data['bannerSubTitle'] = (isset($results[0]['subtitle'])) ? $results[0]['subtitle']:'';

		foreach ($results as $result) {
			if (is_file(DIR_IMAGE . $result['image'])) {
				$data['banners'][] = array(
					'title' => $result['title'],
					'link'  => $result['link'],
					'image' => $this->model_tool_image->resize($result['image'], $setting['width'], $setting['height']),
					'no_cache_image' => $config_url . $result['image'],
					'date' => $result['date'],
					'banner_image_id' => $result['banner_image_id'],
                    'model_id' => $result['model_id'],
				);
			}
		}

		if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/extension/module/slideshow.tpl')){
			return $this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/extension/module/slideshow', $data);
		}else{
			return $this->load->view(DIR_TEMPLATE . 'default/template/extension/module/slideshow', $data);
		}

		
	}
}
