<?php
class ControllerExtensionModulePintaOpenGraph extends Controller
{
    private $setting = array();

    public function index()
    {
        $data = [];
        $this->load->model('setting/setting');
        $this->load->model('catalog/product');
        $this->load->model('catalog/category');
        $this->load->model('catalog/manufacturer');

        $data =array();

        $setting = $this->model_setting_setting->getSetting('pinta_open_graph');
        $self = $this->model_setting_setting->getSetting('config');
        foreach ($setting as $key => $item) {
            $this->setting[$key] = $item;
        }
        if (!empty($this->setting)) {
            if ($this->setting['pinta_open_graph_status'] == 1) {

                if (isset($this->request->get['route'])) {

                    if ($this->request->get['route'] == 'product/product') {

                        $data['schema_product'] = $this->getProduct($self);
                    }
                    if ($this->request->get['route'] == 'common/home') {
                        $data['dafault'] = $this->getDefault($self);
                    }
                } else {
                    $data['dafault'] = $this->getDefault($self);
                }
            }
            return $data;
        }
        return false;
    }

    private function getDefault($self)
    {
        $this->load->model('tool/image');
        $server = $this->request->server['REQUEST_SCHEME'] . '://' . $this->request->server['SERVER_NAME'];
        $images = $this->setting['pinta_open_graph_image_default'];
        $regexp='%[fhtps]{3,5}:\\/\\/[^\\/]+?\\/image/%';
        $image = preg_replace($regexp,'',$images);

        $imag = $this->model_tool_image->resize($image, $this->setting['pinta_open_graph_width_image'],
                $this->setting['pinta_open_graph_height_image']);

        $meta = '
        <meta property="og:type"                   content="website" />
        <meta property="og:title"                  content="' . $self['config_name'] . '" />
        <meta property="og:description"            content="' . implode(" ",$self['config_meta_description']) . '" />
        <meta property="og:url"                    content="' . $server . html_entity_decode($this->request->server['REQUEST_URI']) . '" />';

        if($this->setting['pinta_open_graph_id_application']!=''){
            $meta .= '
        <meta property="fb:app_id"                 content="' . $this->setting['pinta_open_graph_id_application'] . '" />';
        };

        $metaImg = '
        <meta property="og:image"                  content="http://dr.deercase.com/image/cache/arty-case-banner-200x200.jpg" />
        <meta property="og:image:width"            content="' . $this->setting['pinta_open_graph_width_image'] . '" />
        <meta property="og:image:height"           content="' . $this->setting['pinta_open_graph_height_image'] . '" />';
       
        $metaTw = ' 
        <meta name="twitter:card"                  content="summary_large_image" />
        <meta name="twitter:site"                  content="' . $self['config_name'] . '" />
        <meta name="twitter:title"                 content="' . $self['config_name'] . '" />
        <meta name="twitter:description"           content="' . implode(" ",$self['config_meta_description']) . '" />
        <meta name="twitter:url"                   content="' . $server . html_entity_decode($this->request->server['REQUEST_URI']) . '" />';

        $metaTwImg = '
        <meta name="twitter:image"                 content="' . $imag . '" />';

        return $meta . $metaImg .PHP_EOL. $metaTw . $metaTwImg;
    }

    private function getProduct($self)
    {
        $productId = $this->request->get['product_id'];
        $this->load->model('extension/module/pinta_open_graph');
        $this->load->model('catalog/product');

        $product = $this->model_catalog_product->getProduct($productId);
    
        $server = $this->request->server['REQUEST_SCHEME'] . '://' . $this->request->server['SERVER_NAME'];

        if (strpos($product['stock_status'],'Days') !== false){
            $stock = 'preorder';
        } else {
            $stock = strtolower(!empty($product['stock_status'])? $product['stock_status'] : " instock ");
        }

        $text = strip_tags(html_entity_decode($product['description']));

        $meta = '  
        <meta property="og:type"                   content="og:product" />
        <meta property="og:title"                  content="' . $product['name'] . '" />
        <meta property="og:description"            content="' . substr(strip_tags($text), 0, 280) . '" />
        <meta property="og:url"                    content="' . $server . html_entity_decode($this->request->server['REQUEST_URI']) . '" />
        <meta property="og:site_name"              content="' . $self['config_name'] . '" />
        <meta property="product:plural_title"      content="' . $product['name'] . '" />
        <meta property="product:brand"             content="' . $product['manufacturer'] . '" />
        <meta property="product:availability"      content="' . $stock . '" />
        <meta property="product:condition"         content="new">
        <meta property="product:retailer_item_id"  content="'.$productId.'" />';

        if($this->setting['pinta_open_graph_id_application']!=''){
            $meta .= '
        <meta property="fb:app_id"                 content="' . $this->setting['pinta_open_graph_id_application'] . '" />';
        }; 

        $metaTw = ' 
        <meta name="twitter:card"                  content="summary_large_image" />
        <meta name="twitter:site"                  content="' . $product['name'] . '" />
        <meta name="twitter:title"                 content="' . $product['name'] . '" />
        <meta name="twitter:description"           content="' . substr(strip_tags($text), 0, 200) . '" />
        <meta name="twitter:url"                   content="' . $server . html_entity_decode($this->request->server['REQUEST_URI']) . '" />';

        $curency = '';
        foreach ($this->setting['pinta_open_graph_curency'] as $key => $val) {
            if ($val == 1) {
                $curency .= '
        <meta property="product:price:amount"      content="' . $this->getPrice($product['price'], $product['tax_class_id'], $key) . '"/>
        <meta property="product:price:currency"    content="' . $key . '"/>';
            }
        }

        $metaImg = '';
        $metaTwImg = '';

        if( $this->getImage()) {
            $metaImg .= ' 
        <meta property="og:image"                  content="' . $this->getImage() . '" />';
            $metaImg .= '
        <meta property="og:image:width"            content="' . $this->setting['pinta_open_graph_width_image'] . '" />';
            $metaImg .= '
        <meta property="og:image:height"           content="' . $this->setting['pinta_open_graph_height_image'] . '" />';
            $metaTwImg = '
        <meta name="twitter:image"                 content="' . $this->getImage() . '" />';
        } else {
            $metaImg .= '
        <meta property="og:image"                  content="' . $this->setting['pinta_open_graph_image_default'] . '" />';
            $metaImg .= '
        <meta property="og:image:width"            content="' . $this->setting['pinta_open_graph_width_image'] . '" />';
            $metaImg .= '
        <meta property="og:image:height"           content="' . $this->setting['pinta_open_graph_height_image'] . '" />';
            $metaTwImg = '
        <meta name="twitter:image"                 content="' . $this->setting['pinta_open_graph_image_default'] . '" />';
        }

        return $meta . $metaImg . $curency .PHP_EOL. $metaTw . $metaTwImg;
    }

    private function getPrice($price, $tax, $currency)
    {
        $price = $this->currency->format($this->tax->calculate($price, $tax, $this->config->get('config_tax')), $currency);
        $array = array("/[^0-9\.]/");
        $price = preg_replace($array,'',$price);
        return $price;
    }

    private function getImage()
    {
        $this->load->model('tool/image');
        if(!empty($this->request->get['product_id'])) {
            $product = $this->model_catalog_product->getProduct($this->request->get['product_id']);

            if (!empty($product['image'])) {
                $image = $this->model_tool_image->resize($product['image'], $this->setting['pinta_open_graph_width_image'],
                    $this->setting['pinta_open_graph_height_image']);
            } else {
                $image = $this->model_tool_image->resize($this->setting['pinta_open_graph_image_default'], $this->setting['pinta_open_graph_width_image'],
                $this->setting['pinta_open_graph_height_image']);
            }

            return $image;

        }
        return false;
    }

}
