<?php
class ControllerExtensionModuleBanner extends Controller {
	public function index($setting) {

		static $module = 0;

        $data['module'] = $module++;

        if($this->cache->cache_get('banner-' . $this->session->data['language'] . '-' . $this->session->data['currency'] . $data['module'], 'banners/'))
            return $this->cache->cache_get('banner-' . $this->session->data['language'] . '-' . $this->session->data['currency'] . $data['module'], 'banners/');

		$this->load->model('design/banner');
		$this->load->model('tool/image');

		$this->document->addStyle('//scripts.piyersoft.com/javascript/owl-carousel/owl.carousel.css');
		$this->document->addStyle('//scripts.piyersoft.com/javascript/owl-carousel/owl.transitions.css');
		$this->document->addScript('//scripts.piyersoft.com/javascript/owl-carousel/owl.carousel.min.js');

		$data['banners'] = array();

		$results = $this->model_design_banner->getBanner($setting['banner_id']);

		foreach ($results as $result) {
			if (is_file(DIR_IMAGE . $result['image'])) {
				$data['banners'][] = array(
					'title' => $result['title'],
					'link'  => $result['link'],
					'image' => $this->model_tool_image->resize($result['image'], $setting['width'], $setting['height']),
					'no_cache_image' => $result['image']
				);
			}
		}

        $cache = '';
        if ($data['banners']) {
            if (file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/extension/module/banner.tpl')) {
                $cache = $this->load->view(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/extension/module/banner', $data);
            } else {
                $cache = $this->load->view(DIR_TEMPLATE . 'default/template/extension/module/banner', $data);
            }
        }

        $this->cache->cache_set('banner-' . $this->session->data['language'] . '-' . $this->session->data['currency'] . $data['module'], $this->cache->minify_to_html($cache), 'banners/');
        return $this->cache->cache_get('banner-' . $this->session->data['language'] . '-' . $this->session->data['currency'] . $data['module'], 'banners/');


		
	}
}