<?php
class ControllerExtensionFeedGoogleSitemap extends Controller {

    public function index()
    {

        set_time_limit(0);

        if ($this->config->get('google_sitemap_status')) {

            $output  = '<?xml version="1.0" encoding="UTF-8"?>';
            $output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';

            $redis = new Redis();
            $redis->connect('127.0.0.1', 6379);

            $this->load->model('tool/image');

            $products = $this->db->query("SELECT product_id FROM ps_product WHERE status = 1 AND image != '' LIMIT 40000 ")->rows;

            foreach ($products as $product){
                $p_info = $redis->get('google_sitemap_product_' . $product['product_id']);
                if($p_info){
                    $output .= $p_info;
                }
            }

            $output .= '</urlset>';

            $this->response->addHeader('Content-Type: application/xml');
            $this->response->setOutput($output);



        }

    }

    public function link1()
    {

        set_time_limit(0);

        if ($this->config->get('google_sitemap_status')) {

            $output  = '<?xml version="1.0" encoding="UTF-8"?>';
            $output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';

            $redis = new Redis();
            $redis->connect('127.0.0.1', 6379);

            $this->load->model('tool/image');

            $products = $this->db->query("SELECT product_id FROM ps_product WHERE status = 1 AND image != '' LIMIT 0,40000 ")->rows;

            foreach ($products as $product){
                $p_info = $redis->get('google_sitemap_product_' . $product['product_id']);
                if($p_info){
                    $output .= $p_info;
                }
            }

            $output .= '</urlset>';

            $this->response->addHeader('Content-Type: application/xml');
            $this->response->setOutput($output);



        }

    }

    public function link2()
    {

        set_time_limit(0);

        if ($this->config->get('google_sitemap_status')) {

            $output  = '<?xml version="1.0" encoding="UTF-8"?>';
            $output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';

            $redis = new Redis();
            $redis->connect('127.0.0.1', 6379);

            $this->load->model('tool/image');

            $products = $this->db->query("SELECT product_id FROM ps_product WHERE status = 1 AND image != '' LIMIT 40000, 40000 ")->rows;

            foreach ($products as $product){
                $p_info = $redis->get('google_sitemap_product_' . $product['product_id']);
                if($p_info){
                    $output .= $p_info;
                }
            }

            $output .= '</urlset>';

            $this->response->addHeader('Content-Type: application/xml');
            $this->response->setOutput($output);



        }

    }

    public function link3()
    {

        set_time_limit(0);

        if ($this->config->get('google_sitemap_status')) {

            $output  = '<?xml version="1.0" encoding="UTF-8"?>';
            $output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';

            $redis = new Redis();
            $redis->connect('127.0.0.1', 6379);

            $this->load->model('tool/image');

            $products = $this->db->query("SELECT product_id FROM ps_product WHERE status = 1 AND image != '' LIMIT 80000, 40000 ")->rows;

            foreach ($products as $product){
                $p_info = $redis->get('google_sitemap_product_' . $product['product_id']);
                if($p_info){
                    $output .= $p_info;
                }
            }

            $output .= '</urlset>';

            $this->response->addHeader('Content-Type: application/xml');
            $this->response->setOutput($output);



        }

    }

    public function link4()
    {

        set_time_limit(0);

        if ($this->config->get('google_sitemap_status')) {

            $output  = '<?xml version="1.0" encoding="UTF-8"?>';
            $output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';

            $redis = new Redis();
            $redis->connect('127.0.0.1', 6379);

            $this->load->model('tool/image');

            $products = $this->db->query("SELECT product_id FROM ps_product WHERE status = 1 AND image != '' LIMIT 120000, 40000 ")->rows;

            foreach ($products as $product){
                $p_info = $redis->get('google_sitemap_product_' . $product['product_id']);
                if($p_info){
                    $output .= $p_info;
                }
            }

            $output .= '</urlset>';

            $this->response->addHeader('Content-Type: application/xml');
            $this->response->setOutput($output);



        }

    }

    public function link5()
    {

        set_time_limit(0);

        if ($this->config->get('google_sitemap_status')) {

            $output  = '<?xml version="1.0" encoding="UTF-8"?>';
            $output .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">';

            $redis = new Redis();
            $redis->connect('127.0.0.1', 6379);

            $this->load->model('tool/image');

            $products = $this->db->query("SELECT product_id FROM ps_product WHERE status = 1 AND image != '' LIMIT 160000, 40000 ")->rows;

            foreach ($products as $product){
                $p_info = $redis->get('google_sitemap_product_' . $product['product_id']);
                if($p_info){
                    $output .= $p_info;
                }
            }

            $output .= '</urlset>';

            $this->response->addHeader('Content-Type: application/xml');
            $this->response->setOutput($output);



        }

    }

    public function cache()
    {

        if(isset($this->request->get['link'])){
            $rand = (int)$this->request->get['link'];
        }else{
            $rand = rand(1,5);
        }



        $link = '0,40000';
        if($rand == 1){
            $link = '0,40000';
        }else if($rand == 2){
            $link = '40000,40000';
        }else if($rand == 3){
            $link = '80000,40000';
        }else if($rand == 4){
            $link = '120000,40000';
        }else if($rand == 5){
            $link = '160000,40000';
        }

        set_time_limit(0);

        $this->load->model('catalog/product');

        $redis = new Redis();
        $redis->connect('127.0.0.1', 6379);

        $this->load->model('tool/image');


        $products = $this->db->query("SELECT product_id FROM  ps_product WHERE status = 1 AND image != '' LIMIT {$link} ")->rows;

        foreach ($products as $product){

            $p_info = $this->db->query("SELECT p.product_id, p.date_modified, p.product_showcase, p.image, pd.name FROM ps_product p 
            LEFT JOIN ps_product_description pd ON (p.product_id = pd.product_id) 
            WHERE p.product_id = '". (int)$product['product_id'] ."' AND pd.language_id = '1' AND p.status = '1' ")->row;

            //var_dump(date('Y-m-d\TH:i:sP', strtotime($p_info['date_modified']))); die();

            if (isset($p_info['image'])) {
                $output = '<url>';
                $output .= '<loc>' . $this->url->link('product/product', 'product_id=' . $product['product_id']) . '</loc>';
                $output .= '<changefreq>weekly</changefreq>';
                $output .= '<lastmod>' . date('Y-m-d\TH:i:sP') . '</lastmod>';
                $output .= '<priority>'. ($p_info['product_showcase'] ? '0.9' : '0.7') .'</priority>';
                $output .= '<image:image>';
                $output .= '<image:loc>' . $this->model_tool_image->resize($p_info['image'], $this->config->get($this->config->get('config_theme') . '_image_popup_width'), $this->config->get($this->config->get('config_theme') . '_image_popup_height')) . '</image:loc>';
                $output .= '<image:caption><![CDATA[' . $p_info['name'] . ']]></image:caption>';
                $output .= '<image:title><![CDATA[' . $p_info['name'] . ']]></image:title>';
                $output .= '</image:image>';
                $output .= '</url>';

                $redis->set('google_sitemap_product_' . $product['product_id'], $output);
                echo 'google_sitemap_product_' . $product['product_id']. '<br>';

            }


        }


    }

    protected function getCategories($parent_id, $current_path = '') {
        $output = '';

        $results = $this->model_catalog_category->getCategories($parent_id);

        foreach ($results as $result) {


            $output .= '<url>';
            $output .= '<loc>' . $this->url->link('product/category', 'path=' . $result['category_id']) . '</loc>';
            $output .= '<changefreq>weekly</changefreq>';
            $output .= '<priority>0.7</priority>';
            $output .= '</url>';

            $products = $this->model_catalog_product->getProducts(array('filter_category_id' => $result['category_id']));

            foreach ($products as $product) {
                $output .= '<url>';
                $output .= '<loc><![CDATA[' . $this->url->link('product/product', 'path=' . $result['category_id'] . '&product_id=' . $product['product_id']) . ']]></loc>';
                $output .= '<changefreq>weekly</changefreq>';
                $output .= '<priority>1.0</priority>';
                $output .= '</url>';
            }

            //$output .= $this->getCategories($result['category_id']);
        }

        return $output;
    }
}
