<?php
class ControllerCommonFooter extends Controller {
	public function index() {

        #Google Ads
        $data['gaecmadwconv_module'] = $this->load->controller('extension/gaecmadwconv');
        $data['gaecmadwconvfootjs_module'] = $this->load->controller('extension/gaecmadwconv/footjs');
        #Google Ads

        $data['digitcart_load_products'] = $this->load->controller('module/digitcart_load_products');
		$this->load->language('product/search');


		$this->load->language('common/footer');

		$data['scripts'] = $this->document->getScripts('footer');

		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}

		$data['mytemplate'] = $this->config->get('theme_default_directory');

		$data['text_information'] = $this->language->get('text_information');
		$data['text_service'] = $this->language->get('text_service');
		$data['text_extra'] = $this->language->get('text_extra');
		$data['text_contact'] = $this->language->get('text_contact');
		$data['text_return'] = $this->language->get('text_return');
		$data['text_sitemap'] = $this->language->get('text_sitemap');
		$data['text_manufacturer'] = $this->language->get('text_manufacturer');
		$data['text_voucher'] = $this->language->get('text_voucher');
		$data['text_affiliate'] = $this->language->get('text_affiliate');
		$data['text_special'] = $this->language->get('text_special');
		$data['text_account'] = $this->language->get('text_account');
		$data['text_order'] = $this->language->get('text_order');
		$data['text_wishlist'] = $this->language->get('text_wishlist');
		$data['text_newsletter'] = $this->language->get('text_newsletter');
		$data['text_transaction'] = $this->language->get('text_transaction');
		$data['text_download'] = $this->language->get('text_download');
		$data['text_categories'] = $this->language->get('text_categories');
		$data['text_customer_services'] = $this->language->get('text_customer_services');

		$data['text_helping'] = $this->language->get('text_helping');
		$data['text_corporate'] = $this->language->get('text_corporate');
		$data['text_about_us'] = $this->language->get('text_about_us');
		$data['text_contracts'] = $this->language->get('text_contracts');

		$data['text_telephone'] = $this->language->get('text_telephone');
		$data['text_gsm'] = $this->language->get('text_gsm');
		$data['text_call_center'] = $this->language->get('text_call_center');

		$data['text_kurumsal'] = $this->language->get('text_kurumsal');
		$data['text_urun'] = $this->language->get('text_urun');
		$data['text_kurumsallink'] = $this->language->get('text_kurumsallink');
		
		$data['text_home'] = $this->language->get('text_home');

		$data['text_up_button'] = $this->language->get('text_up_button');

		$data['address'] = $this->config->get('config_address');
		$data['config_email'] = $this->config->get('config_email');
		$data['config_telephone'] = $this->config->get('config_telephone');
		$data['config_telephone_2'] = $this->config->get('config_telephone_2');
		$data['config_fax'] = $this->config->get('config_fax');
		$data['config_open'] = $this->config->get('config_open');
		$data['config_address'] = $this->config->get('config_address');
		$data['config_name'] = $this->config->get('config_name');
		$data['config_comment'] = $this->config->get('config_comment');


		//Sipariş sorgulama #Bilal 16/04/2019
		$data['guest_order'] = $this->url->link('account/guestorder', '' , true);
		$data['guest_order_view'] = $this->language->get('auto_logo');
		//Sipariş sorgulama #Bilal 16/04/2019

		if (is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
			$data['logo'] = $server . 'image/' . $this->config->get('config_logo');
		} else {
			$data['logo'] = '';
		}

		$data['customer_info'] = array();


        if ($this->customer->isLogged()) {
            $data['return'] = $this->url->link('account/order', '', true);
            $this->load->model("account/customer");
            $customer_info = $this->model_account_customer->getCustomer($this->customer->getId());
            $data['customer_info'] = array(
                  "uuid" => $customer_info['customer_id'],
                  "name" => $customer_info['firstname'],
                  "surname" => $customer_info['lastname'],
                  "username" => $customer_info['email'],
                  "email" => $customer_info['email'],
                  "phone_number" => $customer_info['telephone'],
            );

        }else{
            $data['return'] = $this->url->link('account/guestorder', '', true);

            $data['customer_info'] = array(
                "uuid" => "",
                "name" => "",
                "surname" => "",
                "username" => "",
                "email" => "",
                "phone_number" => "",
            );

        }

		$data['home'] = $this->url->link('common/home');
		$data['contact'] = $this->url->link('information/contact','', true);
		//$data['return'] = $this->url->link('account/return/add', '', true);
		$data['sitemap'] = $this->url->link('information/sitemap', '' ,true);
		$data['manufacturer'] = $this->url->link('product/manufacturer', '' ,true);
		$data['voucher'] = $this->url->link('account/voucher', '', true);
		$data['affiliate'] = $this->url->link('affiliate/account', '', true);
		$data['special'] = $this->url->link('product/special');
		$data['account'] = $this->url->link('account/account', '', true);
		$data['order'] = $this->url->link('account/order', '', true);
		$data['wishlist'] = $this->url->link('account/wishlist', '', true);
		$data['newsletter'] = $this->url->link('account/newsletter', '', true);

        // Whos Online
        if ($this->config->get('config_customer_online')) {
            $this->load->model('tool/online');

            if (isset($this->request->server['REMOTE_ADDR'])) {
                $ip = $this->request->server['REMOTE_ADDR'];
            } else {
                $ip = '';
            }

            if (isset($this->request->server['HTTP_HOST']) && isset($this->request->server['REQUEST_URI'])) {
                $url = 'http://' . $this->request->server['HTTP_HOST'] . $this->request->server['REQUEST_URI'];
            } else {
                $url = '';
            }

            if (isset($this->request->server['HTTP_REFERER'])) {
                $referer = $this->request->server['HTTP_REFERER'];
            } else {
                $referer = '';
            }


            $this->model_tool_online->addOnline($ip, $this->customer->getId(), $url, $referer);
        }

		return $this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/common/footer', $data);

		
	}
}