<?php
class ControllerAccountRegister extends Controller {
	private $error = array();

	public function index() {
		if ($this->customer->isLogged()) {
			$this->response->redirect($this->url->link('account/account', '', true));
		}

		$this->load->language('account/register');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment.js');
		$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
		$this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');

		$this->load->model('account/customer');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$customer_id = $this->model_account_customer->addCustomer($this->request->post);

			// Clear any previous login attempts for unregistered accounts.
			$this->model_account_customer->deleteLoginAttempts($this->request->post['email']);

			$this->customer->login($this->request->post['email'], $this->request->post['password']);

            $this->load->model('setting/setting');
            $netgsm_ayarlari = $this->model_setting_setting->getSetting('netgsm');


            #NetGSM 2020/06/08 BILAL
            if($netgsm_ayarlari['netgsm_status']==1){
                if(isset($netgsm_ayarlari['netgsm_newuser_to_customer_control']) and $netgsm_ayarlari['netgsm_newuser_to_customer_control']==1 and $netgsm_ayarlari['netgsm_newuser_to_customer_text']!=''){
                    $mesaj = str_replace(array('[uye_adi]','[uye_soyadi]','[uye_telefonu]','[uye_epostasi]','[uye_sifresi]'),array($this->request->post['firstname'],$this->request->post['lastname'],$this->request->post['telephone'],$this->request->post['email'],$this->request->post['password']),$netgsm_ayarlari['netgsm_newuser_to_customer_text']);
                    $netgsmsms = new Netgsmsms($netgsm_ayarlari['netgsm_user'],$netgsm_ayarlari['netgsm_pass'],$netgsm_ayarlari['netgsm_input_smstitle'],$netgsm_ayarlari['netgsm_turkishChar']);
                    $smsgonder = $netgsmsms->sendSMS($this->request->post['telephone'],$mesaj);
                }
            }
            if(isset($netgsm_ayarlari['netgsm_newuser_to_admin_control']) and $netgsm_ayarlari['netgsm_newuser_to_admin_control']==1 and $netgsm_ayarlari['netgsm_newuser_to_admin_text']!=''){
                $mesaj = str_replace(array('[uye_adi]','[uye_soyadi]','[uye_telefonu]','[uye_epostasi]','[uye_sifresi]'),array($this->request->post['firstname'],$this->request->post['lastname'],$this->request->post['telephone'],$this->request->post['email'],$this->request->post['password']),$netgsm_ayarlari['netgsm_newuser_to_admin_text']);
                $netgsmsms = new Netgsmsms($netgsm_ayarlari['netgsm_user'],$netgsm_ayarlari['netgsm_pass'],$netgsm_ayarlari['netgsm_input_smstitle'],$netgsm_ayarlari['netgsm_turkishChar']);
                $smsgonder = $netgsmsms->sendSMS($netgsm_ayarlari['netgsm_newuser_to_admin_no'],$mesaj);
            }

            if($netgsm_ayarlari['netgsm_status']==1){
                if(isset($netgsm_ayarlari['netgsm_rehber_control']) and $netgsm_ayarlari['netgsm_rehber_control']==1 and $netgsm_ayarlari['netgsm_rehber_groupname']!=''){
                    $netgsmsms = new Netgsmsms($netgsm_ayarlari['netgsm_user'],$netgsm_ayarlari['netgsm_pass'],$netgsm_ayarlari['netgsm_input_smstitle'],$netgsm_ayarlari['netgsm_turkishChar']);
                    $grubakaydet = $netgsmsms->addContact($this->request->post['firstname'],$this->request->post['lastname'],$this->request->post['telephone'],$netgsm_ayarlari['netgsm_rehber_groupname']);
                }
            }

            #NetGSM 2020/06/08 BILAL


			unset($this->session->data['guest']);

			// Add to activity log
			if ($this->config->get('config_customer_activity')) {
				$this->load->model('account/activity');

				$activity_data = array(
					'customer_id' => $customer_id,
					'name'        => $this->request->post['firstname'] . ' ' . $this->request->post['lastname']
				);

				$this->model_account_activity->addActivity('register', $activity_data);
			}

			$this->response->redirect($this->url->link('account/success'));
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => ''
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_account'),
			'href' => 'account',
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_register'),
			'href' => 'register'
		);

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_account_already'] = sprintf($this->language->get('text_account_already'), $this->url->link('account/login', '', true));
		$data['text_your_details'] = $this->language->get('text_your_details');
		$data['text_your_address'] = $this->language->get('text_your_address');
		$data['text_your_password'] = $this->language->get('text_your_password');
		$data['text_newsletter'] = $this->language->get('text_newsletter');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_select'] = $this->language->get('text_select');
		$data['text_none'] = $this->language->get('text_none');
		$data['text_loading'] = $this->language->get('text_loading');

		$data['entry_customer_group'] = $this->language->get('entry_customer_group');
		$data['entry_firstname'] = $this->language->get('entry_firstname');
		$data['entry_lastname'] = $this->language->get('entry_lastname');
		$data['entry_email'] = $this->language->get('entry_email');
		$data['entry_telephone'] = $this->language->get('entry_telephone');
		$data['entry_fax'] = $this->language->get('entry_fax');
		$data['entry_company'] = $this->language->get('entry_company');
		$data['entry_address_1'] = $this->language->get('entry_address_1');
		$data['entry_address_2'] = $this->language->get('entry_address_2');
		$data['entry_postcode'] = $this->language->get('entry_postcode');
		$data['entry_city'] = $this->language->get('entry_city');
		$data['entry_country'] = $this->language->get('entry_country');
		$data['entry_zone'] = $this->language->get('entry_zone');
		$data['entry_newsletter'] = $this->language->get('entry_newsletter');
		$data['entry_password'] = $this->language->get('entry_password');
		$data['entry_confirm'] = $this->language->get('entry_confirm');

		$data['button_continue'] = $this->language->get('button_continue');
		$data['button_upload'] = $this->language->get('button_upload');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['firstname'])) {
			$data['error_firstname'] = $this->error['firstname'];
		} else {
			$data['error_firstname'] = '';
		}

		if (isset($this->error['lastname'])) {
			$data['error_lastname'] = $this->error['lastname'];
		} else {
			$data['error_lastname'] = '';
		}

		if (isset($this->error['email'])) {
			$data['error_email'] = $this->error['email'];
		} else {
			$data['error_email'] = '';
		}

		if (isset($this->error['telephone'])) {
			$data['error_telephone'] = $this->error['telephone'];
		} else {
			$data['error_telephone'] = '';
		}

		if (isset($this->error['custom_field'])) {
			$data['error_custom_field'] = $this->error['custom_field'];
		} else {
			$data['error_custom_field'] = array();
		}

		if (isset($this->error['password'])) {
			$data['error_password'] = $this->error['password'];
		} else {
			$data['error_password'] = '';
		}

		if (isset($this->error['confirm'])) {
			$data['error_confirm'] = $this->error['confirm'];
		} else {
			$data['error_confirm'] = '';
		}

		$data['action'] = $this->url->link('account/register', '', true);

		$data['customer_groups'] = array();

		if (is_array($this->config->get('config_customer_group_display'))) {
			$this->load->model('account/customer_group');

			$customer_groups = $this->model_account_customer_group->getCustomerGroups();

			foreach ($customer_groups as $customer_group) {
				if (in_array($customer_group['customer_group_id'], $this->config->get('config_customer_group_display'))) {
					$data['customer_groups'][] = $customer_group;
				}
			}
		}

		if (isset($this->request->post['customer_group_id'])) {
			$data['customer_group_id'] = $this->request->post['customer_group_id'];
		} else {
			$data['customer_group_id'] = $this->config->get('config_customer_group_id');
		}

		if (isset($this->request->post['firstname'])) {
			$data['firstname'] = $this->request->post['firstname'];
		} else {
			$data['firstname'] = '';
		}

		if (isset($this->request->post['lastname'])) {
			$data['lastname'] = $this->request->post['lastname'];
		} else {
			$data['lastname'] = '';
		}

		if (isset($this->request->post['email'])) {
			$data['email'] = $this->request->post['email'];
		} else {
			$data['email'] = '';
		}

		if (isset($this->request->post['telephone'])) {
			$data['telephone'] = $this->request->post['telephone'];
		} else {
			$data['telephone'] = '';
		}

		// Custom Fields
		$this->load->model('account/custom_field');

		$data['custom_fields'] = $this->model_account_custom_field->getCustomFields();

		if (isset($this->request->post['custom_field'])) {
			if (isset($this->request->post['custom_field']['account'])) {
				$account_custom_field = $this->request->post['custom_field']['account'];
			} else {
				$account_custom_field = array();
			}

			if (isset($this->request->post['custom_field']['address'])) {
				$address_custom_field = $this->request->post['custom_field']['address'];
			} else {
				$address_custom_field = array();
			}

			$data['register_custom_field'] = $account_custom_field + $address_custom_field;
		} else {
			$data['register_custom_field'] = array();
		}

		if (isset($this->request->post['password'])) {
			$data['password'] = $this->request->post['password'];
		} else {
			$data['password'] = '';
		}

		if (isset($this->request->post['confirm'])) {
			$data['confirm'] = $this->request->post['confirm'];
		} else {
			$data['confirm'] = '';
		}

		if (isset($this->request->post['newsletter'])) {
			$data['newsletter'] = $this->request->post['newsletter'];
		} else {
			$data['newsletter'] = '';
		}

		// Captcha
		if ($this->config->get($this->config->get('config_captcha') . '_status') && in_array('register', (array)$this->config->get('config_captcha_page'))) {
			$data['captcha'] = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha'), $this->error);
		} else {
			$data['captcha'] = '';
		}

		if ($this->config->get('config_account_id')) {
			$this->load->model('catalog/information');

			$information_info = $this->model_catalog_information->getInformation($this->config->get('config_account_id'));

			if ($information_info) {
				$data['text_agree'] = sprintf($this->language->get('text_agree'), $this->url->link('information/information/agree', 'information_id=' . $this->config->get('config_account_id'), true), $information_info['title'], $information_info['title']);
			} else {
				$data['text_agree'] = '';
			}
		} else {
			$data['text_agree'] = '';
		}

		if (isset($this->request->post['agree'])) {
			$data['agree'] = $this->request->post['agree'];
		} else {
			$data['agree'] = false;
		}


		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

		if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/register.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/register', $data));
		}else{ 
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/account/register', $data));
		}

		
	}

      public function socialRegister() {
		if (!isset($this->session->data['fb_login'])) {
			$this->response->redirect($this->url->link('account/login', '', true));
		}

		$this->load->language('account/register');


		$this->document->setTitle($this->language->get('social_register_heading'));

		$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/moment.js');
		$this->document->addScript('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.js');
		$this->document->addStyle('catalog/view/javascript/jquery/datetimepicker/bootstrap-datetimepicker.min.css');

		$this->load->model('account/customer');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateSocialRegister() ) {
			$password = rand();	
//              if(isset($this->session->data['fb_login'])){
//                $address = $this->session->data['fb_login']['address'];
				$customerdata=array();
				$customerdata['email'] = $this->session->data['fb_login']['customer']['email'];
				$customerdata['password'] = $password;
				$customerdata['firstname'] = $this->session->data['fb_login']['customer']['firstname'];
				$customerdata['lastname'] = $this->session->data['fb_login']['customer']['lastname'];
				$customerdata['fax'] = '';
				$customerdata['telephone'] = $this->request->post['telephone'];
				$customerdata['company'] = '';
				$customerdata['company_id'] = '';
				$customerdata['tax_id'] = '';
				$customerdata['address_1'] = '';
				$customerdata['address_2'] = '';
				$customerdata['city'] = '';
				$customerdata['city_id'] = '';
				$customerdata['postcode'] = '';
				$customerdata['country_id'] = 0;
				$customerdata['zone_id'] = 0;
            $customer_id = $this->model_account_customer->addCustomer($customerdata);

			// Clear any previous login attempts for unregistered accounts.
			$this->model_account_customer->deleteLoginAttempts($customerdata['email']);

			$this->customer->login($customerdata['email'], $customerdata['password']);


			#Ede SMS #Bilal 26/08/2020
            $this->load->model('setting/setting');

            $message_info = $this->model_setting_setting->getSetting('edesms');
            if($message_info){

                $message = str_replace(array('%firstname%','%lastname%','%telephone%','%email%','%password%'),array($customerdata['firstname'],$customerdata['lastname'],$customerdata['telephone'],$customerdata['email'], $customerdata['password']),$message_info['edesms_sms_password_text']);

                require_once(DIR_SYSTEM . 'library/sms.php');

                $sms = new Sms();
                //Send sms user
                $sms->send($message_info['edesms_username'],$message_info['edesms_password'],$message,$customerdata['telephone'],$message_info['edesms_originator']);

                //Send sms admin
                $message = str_replace(array('%firstname%','%lastname%','%telephone%','%email%','%password%'),array($customerdata['firstname'],$customerdata['lastname'],$customerdata['telephone'],$customerdata['email'], $customerdata['password']),$message_info['edesms_member_login_text']);

                $admin_numbers = explode(',',$message_info['edesms_order_notify_gsm']);
                foreach ($admin_numbers as $admin_number) {
                    $sms->send($message_info['edesms_username'],$message_info['edesms_password'],$message,$admin_number,$message_info['edesms_originator']);
                }

            }

			#Ede SMS #Bilal 26/08/2020

			#NetGsm #Bilal 12/04/2020
            $this->load->model('setting/setting');
            $netgsm_ayarlari = $this->model_setting_setting->getSetting('netgsm');

            if($this->config->get('netgsm_status')){
                if($netgsm_ayarlari['netgsm_status'] == 1){
                    if(isset($netgsm_ayarlari['netgsm_newuser_to_customer_control']) and $netgsm_ayarlari['netgsm_newuser_to_customer_control']==1 and $netgsm_ayarlari['netgsm_newuser_to_customer_text']!=''){
                        $mesaj = str_replace(array('[uye_adi]','[uye_soyadi]','[uye_telefonu]','[uye_epostasi]','[uye_sifresi]'),array($customerdata['firstname'],$customerdata['lastname'],$customerdata['telephone'],$customerdata['email'],$customerdata['password']),$netgsm_ayarlari['netgsm_newuser_to_customer_text']);
                        $netgsmsms = new Netgsmsms($netgsm_ayarlari['netgsm_user'],$netgsm_ayarlari['netgsm_pass'],$netgsm_ayarlari['netgsm_input_smstitle'],$netgsm_ayarlari['netgsm_turkishChar']);
                        $smsgonder = $netgsmsms->sendSMS($customerdata['telephone'],$mesaj);
                    }
                }
                if(isset($netgsm_ayarlari['netgsm_newuser_to_admin_control']) and $netgsm_ayarlari['netgsm_newuser_to_admin_control']==1 and $netgsm_ayarlari['netgsm_newuser_to_admin_text']!=''){
                    $mesaj = str_replace(array('[uye_adi]','[uye_soyadi]','[uye_telefonu]','[uye_epostasi]','[uye_sifresi]'),array($customerdata['firstname'],$customerdata['lastname'],$customerdata['telephone'],$customerdata['email'],$customerdata['password']),$netgsm_ayarlari['netgsm_newuser_to_admin_text']);
                    $netgsmsms = new Netgsmsms($netgsm_ayarlari['netgsm_user'],$netgsm_ayarlari['netgsm_pass'],$netgsm_ayarlari['netgsm_input_smstitle'],$netgsm_ayarlari['netgsm_turkishChar']);
                    $smsgonder = $netgsmsms->sendSMS($netgsm_ayarlari['netgsm_newuser_to_admin_no'],$mesaj);
                }

                if($netgsm_ayarlari['netgsm_status']==1){
                    if(isset($netgsm_ayarlari['netgsm_rehber_control']) and $netgsm_ayarlari['netgsm_rehber_control']==1 and $netgsm_ayarlari['netgsm_rehber_groupname']!=''){
                        $netgsmsms = new Netgsmsms($netgsm_ayarlari['netgsm_user'],$netgsm_ayarlari['netgsm_pass'],$netgsm_ayarlari['netgsm_input_smstitle'],$netgsm_ayarlari['netgsm_turkishChar']);
                        $grubakaydet = $netgsmsms->addContact($customerdata['firstname'],$customerdata['lastname'],$customerdata['telephone'],$netgsm_ayarlari['netgsm_rehber_groupname']);
                    }
                }
            }

			#NetGsm #Bilal 12/04/2020


			unset($this->session->data['guest']);

			// Add to activity log
			if ($this->config->get('config_customer_activity')) {
				$this->load->model('account/activity');

				$activity_data = array(
					'customer_id' => $customer_id,
					'name'        => $customerdata['firstname']. ' ' .$customerdata['lastname']
				);

				$this->model_account_activity->addActivity('register', $activity_data);
			}

            if(isset($this->session->data['fb_login']) ){
                $address = $this->session->data['fb_login']['address'];
                unset($this->session->data['fb_login']);
                $this->response->redirect($address);
            }else{
                $this->response->redirect($this->url->link('account/success'));
            }
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_account'),
			'href' => $this->url->link('account/account', '', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('social_register_heading'),
			'href' => $this->url->link('account/socialRegister', '', true)
		);

		$data['heading_title'] = $this->language->get('social_register_heading');
        

		$data['text_account_already'] = sprintf($this->language->get('text_account_already'), $this->url->link('account/login', '', true));
		
		
          $data['button_continue'] = $this->language->get('social_register_heading');
		$data['entry_telephone'] = $this->language->get('entry_telephone');
	

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['telephone'])) {
			$data['error_telephone'] = $this->error['telephone'];
		} else {
			$data['error_telephone'] = '';
		}

		$data['action'] = $this->url->link('account/register/socialRegister', '', true);

		if (isset($this->request->post['telephone'])) {
			$data['telephone'] = $this->request->post['telephone'];
		} else {
			$data['telephone'] = '';
		}

		
		
       

		$data['column_left'] = $this->load->controller('common/column_left');
        /* xml */
		$data['column_login'] = $this->load->controller('common/column_login');
		/* xml */
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

		if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/social_register.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/social_register', $data));
		}else{
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/account/social_register', $data));
		}

		
	}
	private function validateSocialRegister() {
        
		if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
			$this->error['telephone'] = $this->language->get('error_telephone');
		}


		

		return !$this->error;
	}
        

        
	private function validate() {
        

		if ((utf8_strlen(trim($this->request->post['firstname'])) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
			$this->error['firstname'] = $this->language->get('error_firstname');
		}

		if(preg_match("/[a-z]/i", $this->request->post['firstname']) != 1) {
			$this->error['firstname'] = 'Ad bilgisi harf içermelidir.';
		}

		if ((utf8_strlen(trim($this->request->post['lastname'])) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32)) {
			$this->error['lastname'] = $this->language->get('error_lastname');
		}

		if(preg_match("/[a-z]/i", $this->request->post['lastname']) != 1) {
			$this->error['lastname'] = 'Soyad bilgisi harf içermelidir.';
		}

		if ((utf8_strlen($this->request->post['email']) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
			$this->error['email'] = $this->language->get('error_email');
		}

		if ($this->model_account_customer->getTotalCustomersByEmail($this->request->post['email'])) {
			$this->error['warning'] = $this->language->get('error_exists');
		}

		if ((utf8_strlen($this->request->post['telephone']) < 10) || (utf8_strlen($this->request->post['telephone']) > 10)) {
			$this->error['telephone'] = $this->language->get('error_telephone');
		}

        $tel = $this->request->post['telephone'];

        if(isset($tel[0]) AND $tel[0] == '0'){
            $json['error']['telephone'] = "Lütfen numaranızın başına 0 koymayınız!";
        }

        if(!is_numeric($this->request->post['telephone'])){
            $this->error['telephone'] = "Telefon bilgisi sayılardan oluşmalıdır";
        }


		// Customer Group
		if (isset($this->request->post['customer_group_id']) && is_array($this->config->get('config_customer_group_display')) && in_array($this->request->post['customer_group_id'], $this->config->get('config_customer_group_display'))) {
			$customer_group_id = $this->request->post['customer_group_id'];
		} else {
			$customer_group_id = $this->config->get('config_customer_group_id');
		}

		// Custom field validation
		$this->load->model('account/custom_field');

		$custom_fields = $this->model_account_custom_field->getCustomFields($customer_group_id);

		foreach ($custom_fields as $custom_field) {
            if ($custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['location']][$custom_field['custom_field_id']])) {
				$this->error['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
			} elseif (($custom_field['type'] == 'text') && !empty($custom_field['validation']) && !filter_var($this->request->post['custom_field'][$custom_field['location']][$custom_field['custom_field_id']], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => $custom_field['validation'])))) {
            	$this->error['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
            }
		}

		if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
			$this->error['password'] = $this->language->get('error_password');
		}

		if ($this->request->post['confirm'] != $this->request->post['password']) {
			$this->error['confirm'] = $this->language->get('error_confirm');
		}

		// Captcha
		if ($this->config->get($this->config->get('config_captcha') . '_status') && in_array('register', (array)$this->config->get('config_captcha_page'))) {
			$captcha = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha') . '/validate');

			if ($captcha) {
				$this->error['captcha'] = $captcha;
			}
		}

		// Agree to terms
		if ($this->config->get('config_account_id')) {
			$this->load->model('catalog/information');

			$information_info = $this->model_catalog_information->getInformation($this->config->get('config_account_id'));

			if ($information_info && !isset($this->request->post['agree'])) {
				$this->error['warning'] = sprintf($this->language->get('error_agree'), $information_info['title']);
			}
		}

		return !$this->error;
	}

	public function customfield() {
		$json = array();

		$this->load->model('account/custom_field');

		// Customer Group
		if (isset($this->request->get['customer_group_id']) && is_array($this->config->get('config_customer_group_display')) && in_array($this->request->get['customer_group_id'], $this->config->get('config_customer_group_display'))) {
			$customer_group_id = $this->request->get['customer_group_id'];
		} else {
			$customer_group_id = $this->config->get('config_customer_group_id');
		}

		$custom_fields = $this->model_account_custom_field->getCustomFields($customer_group_id);

		foreach ($custom_fields as $custom_field) {
			$json[] = array(
				'custom_field_id' => $custom_field['custom_field_id'],
				'required'        => $custom_field['required']
			);
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}