<?php

//Return Status -- veritabanındaki kayıt
// 0 Geçerli sipariş
// 1 İade
// 2 İptal
// 3 Değişim

class ControllerAccountOrderReturn extends Controller{

    use MngArasYurticiTrait;
    use scottycargo;

    private $error = array();

    public function index()
    {

        if(!$this->customer->isLogged()){
            $this->response->redirect($this->url->link('account/login', '', true));
        }else{

        }

        if(isset($this->request->get['return']) AND $this->request->get['return'] == 0){
            $data['error_return'] = 'Sipariş bulunamadı!';
        }

        $this->load->language('account/return');

        $this->document->setTitle($this->language->get('heading_title'));

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_account'),
            'href' => $this->url->link('account/account', '', true)
        );

        $this->load->model('account/return');

        $url = '';

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('account/order_return', $url, true)
        );

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_empty'] = $this->language->get('text_empty');

        $data['column_return_id'] = $this->language->get('column_return_id');
        $data['column_order_id'] = $this->language->get('column_order_id');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_customer'] = $this->language->get('column_customer');

        $data['button_view'] = $this->language->get('button_view');
        $data['button_continue'] = $this->language->get('button_continue');

        $this->load->model('account/return');

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['returns'] = array();

        $return_total = $this->model_account_return->getTotalReturns();

        $results = $this->model_account_return->getReturns(($page - 1) * 10, 10);

        foreach ($results as $result) {
            $data['returns'][] = array(
                'return_id'  => $result['return_id'],
                'order_id'   => $result['order_id'],
                'name'       => $result['firstname'] . ' ' . $result['lastname'],
                'status'     => $result['status'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'href'       => $this->url->link('account/order_return/info', 'return_id=' . $result['return_id'] . $url, true)
            );
        }

        $pagination = new Pagination();
        $pagination->total = $return_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get($this->config->get('config_theme') . '_product_limit');
        $pagination->url = $this->url->link('account/order_return', 'page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($return_total) ? (($page - 1) * $this->config->get($this->config->get('config_theme') . '_product_limit')) + 1 : 0, ((($page - 1) * $this->config->get($this->config->get('config_theme') . '_product_limit')) > ($return_total - $this->config->get($this->config->get('config_theme') . '_product_limit'))) ? $return_total : ((($page - 1) * $this->config->get($this->config->get('config_theme') . '_product_limit')) + $this->config->get($this->config->get('config_theme') . '_product_limit')), $return_total, ceil($return_total / $this->config->get($this->config->get('config_theme') . '_product_limit')));

        $data['continue'] = $this->url->link('account/account', '', true);

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/order_return_list.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/order_return_list', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/account/order_return_list', $data));
        }


    }

    private function productReturnLimit($order_id, $selected)
    {

        $this->load->model('account/order');

        $order_info = $this->model_account_order->getOrder($order_id);
        if(!$order_info){
            return false;
        }

        $products = $this->model_account_order->getOrderProducts($order_id);
        if(!$products){
            return false;
        }

        $promotion_total = false;

        $totals = $this->model_account_order->getOrderTotals($order_id);
        foreach ($totals as $total) {
            if($total['code'] == 'promotion_total'){
                $promotion_total = true;
            }
        }

        $product_return_limit = 0;
        if(count($products) > 2 AND count($products) < 6){
            $product_return_limit = 2;
        }else if(count($products) > 5 AND count($products) < 9){
            $product_return_limit = 4;
        }else if(count($products) > 8 AND count($products) < 12){
            $product_return_limit = 6;
        }else if(count($products) > 12 AND count($products) < 15){
            $product_return_limit = 8;
        }

        if($product_return_limit < $selected){
            return false;
        }



    }

    public function return_product()
    {

        if(isset($this->session->data['user_id'])){
            //var_dump($this->request->post, $this->request->get); die();
        }



        if(!isset($this->request->get['return_type']) && $this->request->post['product_item']){
            if(!isset($this->request->get['order_id']) || !$this->request->post['product_item']){
                $this->response->redirect($this->url->link('account/order', '', true));
            }

            if(!$this->request->post['product_item'] && !$this->productReturnLimit($this->request->get['order_id'], $this->request->post['product_item'])){
                $this->response->redirect($this->url->link('account/order', '', true));
            }

            if(isset($this->session->data['product_item'])){
                unset($this->session->data['product_item']);
            }


            $this->session->data['product_item'] = array();
            foreach ($this->request->post['product_item'] as $item){
                $this->session->data['product_item'][] = array(
                    'product_id' => $item,
                    'quantity' => $this->request->post['quantity'][$item][0]
                );
            }


            $url = '';
            if(isset($this->request->post['cancel_button'])){
                $url = '&cancel=1';
            }

            if(isset($this->request->post['cancel_button2'])){
                $url = '&cancel=1';
                $this->session->data['prefer_pay_coupon'] = true;
            }

            if(isset($this->request->post['return_button'])){
                $url = '&return=1';
            }

            if(isset($this->request->post['return_button2'])){
                $url = '&return=1';
                $this->session->data['prefer_pay_coupon'] = true;
            }

            $this->response->redirect($this->url->link('account/order_return/add', '&order_id=' . $this->request->get['order_id'] . $url, true));

        }else if(isset($this->request->get['return_type']) && !isset($this->request->post['product_item'])){

            if(isset($this->session->data['product_item'])){
                unset($this->session->data['product_item']);
            }



            $this->response->redirect($this->url->link('account/order_return/add', '&order_id=' . (int)$this->request->get['order_id'] . '&order_product_id=' . (int)$this->request->get['order_product_id'] . '&return_type=change' . '&quantity=' . (int)$this->request->get['quantity'], true));
        }



    }

    private function returnControl($order_id){

        $order_products = $this->db->query("SELECT return_status FROM `ps_order_product` WHERE `order_id` = '". $order_id ."' ")->rows;

        $return_counter = 0;
		foreach($order_products as $item){
			if($item['return_status'] == 2){
				$return_counter++;
			}
		}

		if(count($order_products) == $return_counter){
			return true;
		}
        return false;
    }

    public function add()
    {
        //Form için olanlar.
        ## 0 => Değişim
        ## 1 => İade
        ## 2 => İptal


        $this->load->language('account/return');
        $this->load->model('account/return');
        $url = '';

        $data['change_status'] = 0;

        if(isset($this->request->get['cancel'])){
            $data['change_status'] = 2;
            $url .= '&cancel=1';
        }else if(isset($this->request->get['return'])){
            $data['change_status'] = 1;
            $url .= '&return=1';
        }else{
            $data['change_status'] = 0;
        }


        if($this->request->server['REQUEST_METHOD'] != 'POST'){

            if(!isset($this->request->get['return_type'])){
                if(!isset($this->session->data['product_item'])){
                    $this->response->redirect($this->url->link('account/order', '', true));
                }
            }else if(isset($this->request->get['return_type']) AND $this->request->get['order_product_id']){
                if(isset($this->session->data['product_item'])){
                    unset($this->session->data['product_item']);
                }

                $this->session->data['product_item'][] = array(
                    'product_id' => $this->request->get['order_product_id'],
                    'quantity' => $this->request->get['quantity']
                );
            }


        }




        if(!isset($this->request->get['order_id'])){
            $this->response->redirect($this->url->link('account/order', '', true));
        }

        $order_id = (int)$this->request->get['order_id'];


        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

            //dataLayer
            $dataLayerArray['event'] = "refund";
            $dataLayerArray['ecommerce']['transaction_id'] = $this->request->post['order_id'];

            foreach ($this->request->post['product'] as $_dlKey => $_dlproduct) {
                $dataLayerArray['ecommerce']['items'][] = [
                    'item_name' => $_dlproduct,
                    'item_id' => (isset($this->request->post['product_id'][$_dlKey]))? $this->request->post['product_id'][$_dlKey] : '' ,
                    'price' => (isset($this->request->post['price'][$_dlKey]))? $this->request->post['price'][$_dlKey] : '',
                    'item_brand' => $_dlproduct,
                    'item_variant' => (isset($this->request->post['model'][$_dlKey]))? $this->request->post['model'][$_dlKey] : '',
                    'quantity' => (isset($this->request->post['price'][$_dlKey]))? $this->request->post['price'][$_dlKey] : ''
                ];
            }
            $this->session->data['dataLayerReturnJson'] = json_encode($dataLayerArray);
            //dataLayer end

            if(isset($this->session->data['prefer_pay_coupon'])){
                $this->request->post['prefer_pay_coupon'] = $this->session->data['prefer_pay_coupon'];
            }

            $return_id = $this->model_account_return->addReturn($this->request->post);

            //Yutiçi kargo iptal #BİLAL 19/06/2020

            $url_success = '';

            $this->load->model('account/order');
            $order_info = $this->model_account_order->getOrder($this->request->get['order_id']);
            $scotty_info = $this->db->query("SELECT * FROM ps_order_scottycargo WHERE order_id = '". $order_info['order_id'] ."' ")->row; 
            $yurtici_info = $this->db->query("SELECT * FROM ps_order_yurticikargo WHERE order_id = '". $order_info['order_id'] ."' ")->row; 

            if($data['change_status'] == 2){
                if($this->returnControl($order_info['order_id'])){
                    if($scotty_info) {
                        $this->cancelScottyCargo($scotty_info['scottycargo_barcode']);
                    } else {
                        $this->YURTICI_CANCEL_SHIPPING($order_info);
                    }
                } 
                
            }else if($data['change_status'] == 1 OR $data['change_status'] == 3){
                /*
                if($yurtici_info) { // sipariş yurtiçi ile teslim edilmişse iade kodunu yurtiçinden al. - Can 25.01.2022
                    $return_shipping_code = $this->YURTICI_RETURN_SHIPPING_CODE($order_info);
                } else { // değilse yurtiçi genel iade kodunu kullan.
                    $return_shipping_code = '159357';
                }
                */
                $return_shipping_code = '159357';
               $url_success = '&return_shipping_code=' . $return_shipping_code;
               $this->load->model('checkout/order');
               $order_status_id = 20; // İade sürecinde
                $comment = sprintf($this->language->get('text_return_message_text'),$return_shipping_code);
               $this->model_checkout_order->addOrderHistory($order_info['order_id'],$order_status_id,$comment ,true);


                #NetGSM 2020/06/08 BILAL

                $this->load->model('setting/setting');
                $netgsm_ayarlari = $this->model_setting_setting->getSetting('netgsm');

                if($netgsm_ayarlari['netgsm_status'] == 1 && $return_shipping_code!==null){ // && $return_shipping_code!==null  gönderi kodunun 0 gitmemesi için geçiçi olarak eklendi -Can 24.01.2022
                    $text_mesaj = sprintf($this->language->get('text_return_message_text_sms'),$return_shipping_code);
                    $netgsmsms = new Netgsmsms($netgsm_ayarlari['netgsm_user'],$netgsm_ayarlari['netgsm_pass'],$netgsm_ayarlari['netgsm_input_smstitle'],1);
                    $order_info = $this->db->query("SELECT telephone FROM ps_order WHERE order_id = '". $order_id ."' ")->row;
                    $netgsmsms->sendSMS($order_info['telephone'],$text_mesaj);
                }


                #NetGSM 2020/06/08 BILAL
            }


            //Yutiçi kargo iptal #BİLAL 19/06/2020




            //Prfer Pay Coupon #Bilal 29/11/2020

            if(isset($this->session->data['prefer_pay_coupon'])){
               /* $prefer_pay_coupon_total = $this->model_account_return->calcPreferPayCoupon($this->session->data['product_item']);

                $create_coupon = $this->model_account_return->createPreferPayCoupon($order_id, $prefer_pay_coupon_total);


                $this->load->model('setting/setting');
                $netgsm_ayarlari = $this->model_setting_setting->getSetting('netgsm');

                if($netgsm_ayarlari['netgsm_status'] == 1){
                    //$text_mesaj = sprintf($this->language->get('text_return_message_text_sms'),$return_shipping_code);
                    $text_mesaj = sprintf("İade için oluşturulan kupon: %s", $create_coupon);
                    $netgsmsms = new Netgsmsms($netgsm_ayarlari['netgsm_user'],$netgsm_ayarlari['netgsm_pass'],$netgsm_ayarlari['netgsm_input_smstitle'],$netgsm_ayarlari['netgsm_turkishChar']);
                    $order_info = $this->db->query("SELECT telephone FROM ps_order WHERE order_id = '". $order_id ."' ")->row;
                    $netgsmsms->sendSMS($order_info['telephone'],$text_mesaj);
                } */

            }

            //Prfer Pay Coupon #Bilal 29/11/2020


            // Add to activity log
            if ($this->config->get('config_customer_activity')) {
                $this->load->model('account/activity');

                if ($this->customer->isLogged()) {
                    $activity_data = array(
                        'customer_id' => $this->customer->getId(),
                        'name'        => $this->customer->getFirstName() . ' ' . $this->customer->getLastName(),
                        'return_id'   => $return_id
                    );

                    $this->model_account_activity->addActivity('return_account', $activity_data);
                } else {
                    $activity_data = array(
                        'name'      => $this->request->post['firstname'] . ' ' . $this->request->post['lastname'],
                        'return_id' => $return_id
                    );

                    $this->model_account_activity->addActivity('return_guest', $activity_data);
                }
            }

            
            /**
             * Siparişler kargoya verildikten sonra Logo'ya aktarılır.
             * Bir sipariş kargoya verildikten sonra iptal edilemeyeceğinden, sadece iade durumunun Logo'ya aktarılması yeterlidir.
             * -Can 18.03.2022
             */
            $this->load->model('setting/setting');
            $logo_settings = $this->model_setting_setting->getSetting('logo');

            if($data['change_status'] == 1 && $logo_settings['logo_status'] == 1) { # 1 : İade
                $product_ids = implode(",",$this->request->post['order_product_id']);

                $this->load->model('module/logo');
                $this->model_module_logo->returnOrder($product_ids, $this->request->post);
            }

            unset($this->session->data['prefer_pay_coupon']);
            $this->response->redirect($this->url->link('account/order_return/success', '' . $url_success, true));
        }


        $data['text_description'] = $this->language->get('text_description');
        $data['text_order'] = $this->language->get('text_order');
        $data['text_product'] = $this->language->get('text_product');
        $data['text_yes'] = $this->language->get('text_yes');
        $data['text_no'] = $this->language->get('text_no');

        $this->document->setTitle($this->language->get('heading_title'));

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_account'),
            'href' => $this->url->link('account/account', '', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('account/order_return', '', true)
        );

        $data['heading_title'] = $this->language->get('heading_title');

        $data['entry_quantity'] = $this->language->get('entry_quantity');
        $data['entry_reason'] = $this->language->get('entry_reason');
        $data['entry_opened'] = $this->language->get('entry_opened');
        $data['entry_fault_detail'] = $this->language->get('entry_fault_detail');

        $data['button_submit'] = $this->language->get('button_submit');
        $data['button_back'] = $this->language->get('button_back');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['reason'])) {
            $data['error_reason'] = $this->error['reason'];
        } else {
            $data['error_reason'] = '';
        }

        if (isset($this->error['comment'])) {
            $data['error_comment'] = $this->error['comment'];
        } else {
            $data['error_comment'] = '';
        }


        $data['action'] = $this->url->link('account/order_return/add', '&order_id=' . $order_id . $url, true);

        $this->load->model('account/return');


        $this->load->model('account/order');
        $order_info = $this->model_account_order->getOrder($order_id);

        if(!$order_info){
            $this->response->redirect($this->url->link('account/order_return', '', true));
        }

        $this->load->model('checkout/order');

        $this->load->model('tool/image');



        $return_total = 0;
        $data['order_products'] = array();
        foreach ($this->session->data['product_item'] as $item){
            $product_info = $this->model_account_order->getOrderProduct($order_id, $item['product_id']);
            $data['order_products'][] = array(
                'order_product_id' => $item['product_id'],
                'product_id' => $product_info['product_id'],
                'product_name' => strip_tags($product_info['name']),
                'model' => $product_info['model'],
                'quantity' => $item['quantity'],
                'price' => $this->currency->format(($product_info['price'] + $product_info['tax']), $order_info['currency_code'], $order_info['currency_value']),
                'image' => $this->model_tool_image->resize($product_info['case_order_image'], 200, 200)
            );
            $return_total += (($product_info['price'] + $product_info['tax']) * $item['quantity']);
        }



        $order_detail = $this->model_checkout_order->getOrder($order_id);

        $data['order_detail'] = array(
            'order_id' => $order_id,
            'firstname' => $order_detail['firstname'],
            'lastname' => $order_detail['lastname'],
            'telephone' => $order_detail['telephone'],
            'email' => $order_detail['email'],
            'payment_address' => $order_detail['payment_address_1'],
            'shipping_address' => $order_detail['shipping_address_1'],
            'shipping_city' => $order_detail['shipping_city'],
            'shipping_zone' => $order_detail['shipping_zone'],
            'payment_method' => $order_detail['payment_method'],
            'total' => $this->currency->format($order_detail['total'], $order_detail['currency_code'], $order_detail['currency_value']),
            'date' => date($this->language->get('date_format_short'), strtotime($order_detail['date_added']))
        );

        $data['return_total'] = $this->currency->format($return_total, $order_detail['currency_code'], $order_detail['currency_value']);


        if (isset($this->request->post['quantity'])) {
            $data['quantity'] = $this->request->post['quantity'];
        } else {
            $data['quantity'] = 1;
        }

        if (isset($this->request->post['opened'])) {
            $data['opened'] = $this->request->post['opened'];
        } else {
            $data['opened'] = false;
        }

        if (isset($this->request->post['return_or_change'])) {
            $data['return_or_change'] = $this->request->post['return_or_change'];
        } else {
            $data['return_or_change'] = false;
        }

        if (isset($this->request->post['return_reason_id'])) {
            $data['return_reason_id'] = $this->request->post['return_reason_id'];
        } else {
            $data['return_reason_id'] = '';
        }

        $this->load->model('localisation/return_reason');

        $data['return_reasons'] = $this->model_localisation_return_reason->getReturnReasons();

        if (isset($this->request->post['comment'])) {
            $data['comment'] = $this->request->post['comment'];
        } else {
            $data['comment'] = '';
        }

        // Captcha
        if ($this->config->get($this->config->get('config_captcha') . '_status') && in_array('return', (array)$this->config->get('config_captcha_page'))) {
            $data['captcha'] = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha'), $this->error);
        } else {
            $data['captcha'] = '';
        }

        if ($this->config->get('config_return_id')) {
            $this->load->model('catalog/information');

            $information_info = $this->model_catalog_information->getInformation($this->config->get('config_return_id'));

            if ($information_info) {
                $data['text_agree'] = sprintf($this->language->get('text_agree'), $this->url->link('information/information/agree', 'information_id=' . $this->config->get('config_return_id'), true), $information_info['title'], $information_info['title']);
            } else {
                $data['text_agree'] = '';
            }
        } else {
            $data['text_agree'] = '';
        }

        if (isset($this->request->post['agree'])) {
            $data['agree'] = $this->request->post['agree'];
        } else {
            $data['agree'] = false;
        }

        $data['back'] = $this->url->link('account/account', '', true);

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/order_return_form.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/order_return_form', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/account/order_return_form', $data));
        }

    }

    public function info() {
        $this->load->language('account/return');

        if (isset($this->request->get['return_id'])) {
            $return_id = $this->request->get['return_id'];
        } else {
            $return_id = 0;
        }

        if (!$this->customer->isLogged()) {
            $this->session->data['redirect'] = $this->url->link('account/order_return/info', 'return_id=' . $return_id, true);

            $this->response->redirect($this->url->link('account/login', '', true));
        }

        $this->load->model('account/return');

        $return_info = $this->model_account_return->getReturn($return_id);

        if ($return_info) {
            $this->document->setTitle($this->language->get('text_return'));

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/home', '', true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_account'),
                'href' => $this->url->link('account/account', '', true)
            );

            $url = '';

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('account/return', $url, true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_return'),
                'href' => $this->url->link('account/order_return/info', 'return_id=' . $this->request->get['return_id'] . $url, true)
            );

            $data['heading_title'] = $this->language->get('text_return');

            $data['text_return_detail'] = $this->language->get('text_return_detail');
            $data['text_return_id'] = $this->language->get('text_return_id');
            $data['text_order_id'] = $this->language->get('text_order_id');
            $data['text_date_ordered'] = $this->language->get('text_date_ordered');
            $data['text_customer'] = $this->language->get('text_customer');
            $data['text_email'] = $this->language->get('text_email');
            $data['text_telephone'] = $this->language->get('text_telephone');
            $data['text_status'] = $this->language->get('text_status');
            $data['text_date_added'] = $this->language->get('text_date_added');
            $data['text_product'] = $this->language->get('text_product');
            $data['text_reason'] = $this->language->get('text_reason');
            $data['text_comment'] = $this->language->get('text_comment');
            $data['text_history'] = $this->language->get('text_history');
            $data['text_no_results'] = $this->language->get('text_no_results');

            $data['column_product'] = $this->language->get('column_product');
            $data['column_model'] = $this->language->get('column_model');
            $data['column_quantity'] = $this->language->get('column_quantity');
            $data['column_opened'] = $this->language->get('column_opened');
            $data['column_reason'] = $this->language->get('column_reason');
            $data['column_action'] = $this->language->get('column_action');
            $data['column_date_added'] = $this->language->get('column_date_added');
            $data['column_status'] = $this->language->get('column_status');
            $data['column_comment'] = $this->language->get('column_comment');

            $data['button_continue'] = $this->language->get('button_continue');

            $data['return_id'] = $return_info['return_id'];
            $data['order_id'] = $return_info['order_id'];
            $data['date_ordered'] = date($this->language->get('date_format_short'), strtotime($return_info['date_ordered']));
            $data['date_added'] = date($this->language->get('date_format_short'), strtotime($return_info['date_added']));
            $data['firstname'] = $return_info['firstname'];
            $data['lastname'] = $return_info['lastname'];
            $data['email'] = $return_info['email'];
            $data['telephone'] = $return_info['telephone'];
            $data['product'] = $return_info['product'];
            $data['model'] = $return_info['model'];
            $data['quantity'] = $return_info['quantity'];
            $data['reason'] = $return_info['reason'];
            $data['opened'] = $return_info['opened'] ? $this->language->get('text_yes') : $this->language->get('text_no');
            $data['comment'] = nl2br($return_info['comment']);
            $data['action'] = $return_info['action'];

            $data['histories'] = array();

            $results = $this->model_account_return->getReturnHistories($this->request->get['return_id']);

            foreach ($results as $result) {
                $data['histories'][] = array(
                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'status'     => $result['status'],
                    'comment'    => nl2br($result['comment'])
                );
            }

            $data['continue'] = $this->url->link('account/order_return', $url, true);

            $data['column_left'] = $this->load->controller('common/column_left');
            $data['column_right'] = $this->load->controller('common/column_right');
            $data['content_top'] = $this->load->controller('common/content_top');
            $data['content_bottom'] = $this->load->controller('common/content_bottom');
            $data['footer'] = $this->load->controller('common/footer');
            $data['header'] = $this->load->controller('common/header');

            if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/return_info.tpl')){
                $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/return_info', $data));
            }else{
                $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/account/return_info', $data));
            }


        } else {
            $this->document->setTitle($this->language->get('text_return'));

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/home')
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_account'),
                'href' => $this->url->link('account/account', '', true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('account/order_return', '', true)
            );

            $url = '';

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_return'),
                'href' => $this->url->link('account/order_return/info', 'return_id=' . $return_id . $url, true)
            );

            $data['heading_title'] = $this->language->get('text_return');

            $data['text_error'] = $this->language->get('text_error');

            $data['button_continue'] = $this->language->get('button_continue');

            $data['continue'] = $this->url->link('account/order_return', '', true);

            $data['column_left'] = $this->load->controller('common/column_left');
            $data['column_right'] = $this->load->controller('common/column_right');
            $data['content_top'] = $this->load->controller('common/content_top');
            $data['content_bottom'] = $this->load->controller('common/content_bottom');
            $data['footer'] = $this->load->controller('common/footer');
            $data['header'] = $this->load->controller('common/header');

            if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/error/not_found.tpl')){
                $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/error/not_found', $data));
            }else{
                $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/error/not_found', $data));
            }


        }
    }

    protected function validate() {

        if (empty($this->request->post['return_reason_id'])) {
            $this->error['reason'] = $this->language->get('error_reason');
        }

        if (empty($this->request->post['comment'])) {
            $this->error['comment'] = "Lütfen detay belirtiniz.";
        }

        if ($this->config->get($this->config->get('config_captcha') . '_status') && in_array('return', (array)$this->config->get('config_captcha_page'))) {
            $captcha = $this->load->controller('extension/captcha/' . $this->config->get('config_captcha') . '/validate');

            if ($captcha) {
                $this->error['captcha'] = $captcha;
            }
        }

        if ($this->config->get('config_return_id')) {
            $this->load->model('catalog/information');

            $information_info = $this->model_catalog_information->getInformation($this->config->get('config_return_id'));

            if ($information_info && !isset($this->request->post['agree'])) {
                $this->error['warning'] = sprintf($this->language->get('error_agree'), $information_info['title']);
            }
        }

        return !$this->error;
    }

    public function success() {

        $this->load->language('account/return');

        $this->document->setTitle($this->language->get('heading_title'));

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('account/order_return', '', true)
        );

        if(isset($this->request->get['return_shipping_code'])){
            $return_shipping_code = $this->request->get['return_shipping_code'];
        }else{
            $return_shipping_code = '';
        }

        $data['heading_title'] = $this->language->get('heading_title');

        if($return_shipping_code){
            $data['text_message'] = sprintf($this->language->get('text_return_message'),$return_shipping_code);
        }else{
            $data['text_message'] = $this->language->get('text_cancel_message');
        }


        $data['button_continue'] = $this->language->get('button_continue');

        $data['continue'] = $this->url->link('common/home');

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        $data['dataLayerReturnJson'] = '{}';
        if (isset($this->session->data['dataLayerReturnJson'])) {
            $data['dataLayerReturnJson'] = $this->session->data['dataLayerReturnJson'];
        }

        if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/common/success.tpl')){
            $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/common/success', $data));
        }else{
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/common/success', $data));
        }


    }

}