<?php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

class ControllerAccountHalitDev extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('account/forgotten');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('account/customer');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->load->language('mail/forgotten');
            $this->load->model('setting/setting');

            $subject = sprintf($this->language->get('text_subject'), html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
            $code = token(40);
            $this->model_account_customer->editCode($this->request->post['email'], $code);

            $message = sprintf($this->language->get('text_greeting'), html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8')) . "\n\n";
            $message .= $this->language->get('text_change') . "\n\n";
            $message .= $this->url->link('account/reset', 'code=' . $code, true) . "\n\n";
            $message .= sprintf($this->language->get('text_ip'), $this->request->server['REMOTE_ADDR']) . "\n\n";

            require DIR_SYSTEM . 'mailers/GlobalMail.php';
            $mail = new GlobalMail();
            try {
                $mail->setProtocolName('phpmailer');
                $mail->debug = $this->config->get('config_mail_debug');
                $mail->host = $this->config->get('config_mail_smtp_hostname');
                $mail->SMTPAuth = true;
                $mail->userName = $this->config->get('config_mail_smtp_username');
                $mail->password = $this->config->get('config_mail_smtp_password');
                $mail->SMTPSecure = 'ssl';
                $mail->port = $this->config->get('config_mail_smtp_port');

                $mail->setFrom($this->config->get('config_mail_parameter'), 'Deercase');
                $mail->setSubject(html_entity_decode($subject, ENT_QUOTES, 'UTF-8'));
                $mail->setBody(html_entity_decode($message, ENT_QUOTES, 'UTF-8'));
                $mail->setTo($this->request->post['email'], 'Sayin');
                $response = $mail->send();
                if ($response['success']) {
                    $this->session->data['success'] = $this->language->get('text_success');
                    $this->response->redirect($this->url->link('account/login', '', true));
                } else {
                    $this->session->data['success'] = "İşlemler Sırasında Bir Hata Oluştu!";
                    $this->response->redirect($this->url->link('account/login', '', true));
                }
            } catch (Exception $e) {
                echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                die;
            }
        }

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => ''
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_account'),
            'href' => 'account'
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_forgotten'),
            'href' => 'forgotten'
        );

        $data['heading_title'] = $this->language->get('heading_title');
        $data['text_your_email'] = $this->language->get('text_your_email');
        $data['text_email'] = $this->language->get('text_email');
        $data['entry_email'] = $this->language->get('entry_email');
        $data['button_continue'] = $this->language->get('button_continue');
        $data['button_back'] = $this->language->get('button_back');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['action'] = $this->url->link('account/halit_dev', '', true);
        $data['back'] = 'login';

        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } else {
            $data['email'] = '';
        }

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        if (file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/account/halit_dev.tpl')) {
            $this->response->setOutput($this->load->view(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') . '/template/account/halit_dev', $data));
        } else {
            $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/account/halit_dev', $data));
        }


    }

    protected function validate()
    {
        if (!isset($this->request->post['email'])) {
            $this->error['warning'] = $this->language->get('error_email');
        } elseif (!$this->model_account_customer->getTotalCustomersByEmail($this->request->post['email'])) {
            $this->error['warning'] = $this->language->get('error_email');
        }

        $customer_info = $this->model_account_customer->getCustomerByEmail($this->request->post['email']);

        if ($customer_info && !$customer_info['approved']) {
            $this->error['warning'] = $this->language->get('error_approved');
        }

        return !$this->error;
    }

}
