<?php
class ControllerAccountCoupon extends Controller {

	public function index() {


		if (!$this->customer->isLogged()) {
			$this->session->data['redirect'] = $this->url->link('account/account', '', true);
			$this->response->redirect($this->url->link('account/login', '', true));
		}

		$this->load->language('account/coupon');

		$this->document->setTitle($this->language->get('heading_title'));

	
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_account'),
			'href' => $this->url->link('account/account', '', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_voucher'),
			'href' => $this->url->link('account/voucher', '', true)
		);

		$data['heading_title'] = $this->language->get('heading_title');


		$this->load->model('account/customer');

		$coupons = $this->model_account_customer->getCoupons();

		$data['coupons'] = array();

		foreach($coupons as $coupon){
			$data['coupons'][] = array(
				'order_id' => $coupon['order_id'],
				'name' => $coupon['name'],
				'code' => $coupon['code'],
				'coupon_id' => $coupon['coupon_id'],
				'customer_id' => $coupon['customer_id'],
				'type' => $coupon['type'],
				'discount' => $coupon['discount'],
				'date_start' => $coupon['date_start'],
				'date_end' => $coupon['date_end'],
				'status' => $coupon['status'],
			);
		}


		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

		if(file_exists(DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/coupon.tpl')){
		    $this->response->setOutput($this->load->view( DIR_LOCAL_TEMPLATE . $this->config->get('theme_default_directory') .'/template/account/coupon', $data));
		}else{ 
		    $this->response->setOutput($this->load->view(DIR_TEMPLATE . 'default/template/account/coupon', $data));
		}

		
	}

}
